# EnvisalinkController

*EnvisalinkController* is an extension for [Reactor (Multi-System)](https://reactor.toggledbits.com/) that makes entities available for [Eyezon](https://www.eyezon.com/index.html) Envisalink EVL4-connected Honeywell and DSC alarm panels.

**NOTE:** At this moment, only Honeywell Vista panels have been implemented and tested.

## Installation

Installation of this controller is the same as for other extension controllers:

1. Create, if it doesn't already exist, an `ext` subdirectory in your `config` directory;
2. Create, if it doesn't already exist, an `EnvisalinkController` subdirectory under your `config/ext` directory;
3. Unzip the contents of the distribution archive into the directory created in step 2;
4. Add the controller to the `controllers` section of `reactor.yaml`.

The following is a sample configuration:

```
controllers:
  - id: envisalink
    enabled: true
    implementation: EnvisalinkController
    name: Envisalink
    config:
      host: "192.168.0.139"
      #port: 4025
      #password: user
      panel: honeywell
      usercode: "1234"
      partitions: 1
      zones: 32
```

If you have multiple Envisalink devices, you may create an additional controller instance for each, making sure to give each a unique controller ID.

## Configuration

| Config Key | Description |
| ---------- | ----------- |
| `host` | (string) The IP address or hostname of the Envisalink controller on your LAN. This is required and there is no default. Your EVL4 should have a fixed IP address (either statically configured on the controller, or via DHCP address reservation). |
| `port` | (int) The port number. This key is optional; the default is 4025. |
| `panel` | (string) The type of panel connected; must be `honeywell` or `dsc`. Currently, only Honeywell panels are supported. This key is optional; the default is `honeywell`. |
| `password` | (string) The password for login to the EVL4 locally (optional, default: `user`). The password for your EVL4 can be changed in its local web interface. |
| `usercode` | (string) The four-digit user code (as a quote-enclosed string) to use for arming/disarming actions. This is required and there is no default. For better security, you can create a separate user code that is "arm-only" (cannot disarm, also known as a *maid code*) to allow Reactor to arm the system, but require manual disarm by a human at a keypad. Under no circumstances should you use the installer code. |
| `partitions` | (int) The number of partitions in your system. Most residential systems use only one partition. This value is optional; default is 1. You may set this to 0 to keep the *Controller* from publishing partitional-related entities. |
| `zones` | (int) The zone capacity of your system. If you're not sure, open the Envisalink UI or your account on their web site and see what it reports. The default is 64. You may specify 0 to keep the *Controller* from publishing zone-related entities. |
| `function_keys` | (object) This optional object creates actions in the `x_envisalink` capability to simulate press of the function keys on keypads (when supported). The keys of the object are the function key, and the values are the action name. So, for example, `D: stay` in the object definition would create an action `x_envisalink.key_stay` that would send the `D` keycode to the alarm panel, simulating the press of the *D* key on the keypad. On most panels, these keys are programmable, so their functions are installation-specific. They are often used for fire/police panic buttons, silent alarms, and codeless arming.

## Attributes

Panel status information is made available in various attributes added to the system entity for the *Controller* instance (that is, the entity having ID `system`).

| Attribute | Description |
| `battery_maintenance.charging` | (boolean) Charging state of the battery (see *Peculiarities*, below). |
| `battery_maintenance.rechargeable` | (boolean) This value is always *true*. |
| `battery_maintenance.replace` | (boolean) This value is always *null*, because the EVL4 does not/can not report the maintenance condition of the panel battery. |
| `battery_maintenance.state` | (string) Will be `normal`, or `maintenance` if a low-battery condition is reported by the panel. |
| `battery_power.level` | (real) Battery level reported by panel (see *Peculiarities* below). |
| `battery_power.since` | (timestamp) Time at which the battery level was last updated. |
| `power_source.source` | (string) Will be `ac` when AC power is available, `battery` otherwise. |
| `security_mode.mode` | (string) Arming state of the panel: `disarmed`, `away`, `stay`, `instant`, or `max` (see *Peculiarities* below). |
| `security_mode.ready` | (boolean) *true* if the panel is ready to arm when disarmed. |
| `string_sensor.value` | (string) Message string displayed on alphanumeric keypads. |
| `sys_system.state` | (boolean) *true* when *EnvisalinkController* is connected to the panel; *false* otherwise. |
| `x_envisalink.reconnects` | (int) Count of reconnects to the EVL4 since startup; if this number is growing, it indicates a connection stability problem. |
| `x_envisalink.status` | (array of strings) Human-readable status information derived from the (binary) status word. Possible strings include: `ARMED STAY`, `LOW BATTERY`, `FIRE`, `READY`, `SYSTEM TROUBLE`, `ALARM (FIRE ZONE)`, `ARMED (INSTANT)`, `CHIME`, `BYPASS`, `AC PRESENT`, `ARMED AWAY`, `ALARM IN MEMORY`, `ALARM`. These strings are stable and will appear in English only, even if the panel is configured for another language. |
| `x_envisalink.status_mask` | (int) Status reported by a EVL4 (two byte word). Individual bits in this word convey status/icon information. |
| `x_envisalink.zones_faulted` | (array of entity IDs) List of faulted zones. The IDs in the list are not canonical, so if you use these you may need to apply the controller's ID as a prefix. For example, if your controller instance has ID `alarm`, and zone 1 is faulted, you would see `zone01` in this list, and to get its canonical ID would need to expand it to `alarm>zone01`. |

Each partition and zone published will have an entity with the `binary_sensor` capability to reflect its state. For partitions, the *true* (tripped) state means the partition is ready to arm. For zones, the *true* (tripped) state means the zone is faulted (e.g. door open).

The `in_alarm` entity has the `binary_sensor` capability and will be *true* when the panel is in alarm. The `trouble` entity has the `binary_sensor` capability and will be *true* when the panel signals trouble (e.g. low battery on a wireless zone, tamper, etc.).

## Actions

The `security_mode.set_mode` action can be used to change the arming state of the panel. It relies on the user code configured in the `usercode` key. See *Peculiarities* below.

The `x_envisalink.send_command` action can be used to send raw keypad data to the panel. That is, a string sent via this action is the same as the equivalent buttons being pressed on a keypad. The EVL4 supports characters `0-9`, `*` and `#` in this data.

## Peculiarities

* Zone open/faulted status will update almost instantly when a zone faults, but restore is time-based for Honeywell panels, so it may take up to a minute for a zone to restore. That is, if you open a door, the open status will be reported immediately, but the closed status may take up to a minute to follow. See the Envisalink documentation for further explanation.
* There's no message or command that exposes the full list of zones and zone names in use at the panel. The controller will attempt to gradually learn the zone names by parsing the alphanumeric message displayed when a zone is faulted. The names of zone entities can be changed by using the *Rename* button for the related entity in the *Entities* list.
* Honeywell panels don't report detailed battery status, so the battery will always show *charging* when AC power is available, and the battery level will be either 1 or 0 (0 is reported when the panel signals `LOW BATTERY`).
* Only one network connection at a time is supported by the Envisalink, so if something else is connected to it, this controller cannot connect. There is a [proxy available at npmjs.com](https://www.npmjs.com/package/envisalink-proxy) that you could use to support multiple connections if necessary.
* Not all (Honeywell) panels support *max* (maximum) arming (similar to *away* but without the entry delay). The command is ignored if the mode is not supported.
* With great power comes great responsibility.

## Support

If you need support, please post in the [Multi-System Reactor category on the Smarthome.Community](https://smarthome.community/category/22/multi-system-reactor). Please be sure to read and follow the [posting guidelines](https://smarthome.community/topic/768/category-topic-guide-read-before-posting).

<small>Updated: 2025-Apr-09</small>
