# HTDLyncController

*HTDLyncController* is an extension for [Reactor (Multi-System)](https://reactor.toggledbits.com/) that makes entities available for [Home Theater Direct's Lync 6 and 12](https://www.htd.com/Whole-House-Audio/Lync) whole-house audio systems.

## Installation

Installation of this controller is the same as for other extension controllers:

1. Create, if it doesn't already exist, an `ext` subdirectory in your `config` directory;
2. Create, if it doesn't already exist, an `HTDLyncController` subdirectory under your `config/ext` directory;
3. Unzip the contents of the distribution archive into the directory created in step 2;
4. Add the controller to the `controllers` section of `reactor.yaml`.

The following is a sample configuration:

```
controllers:
  - id: htdlync
    enabled: true
    implementation: HTDLyncController
    name: HTDLync
    config:
      host: "192.168.0.139"
      #port: 10006
      zones: 6  # or 12 for Lync 12
```

If you have multiple HTDLync devices, you may create an additional controller instance for each, making sure to give each a unique controller ID.

## Configuration

| Config Key | Description |
| ---------- | ----------- |
| `host` | (string) The IP address or hostname of the HTDLync controller on your LAN. This is required and there is no default. Your EVL4 should have a fixed IP address (either statically configured on the controller, or via DHCP address reservation). |
| `port` | (int) The port number. This key is optional; the default is 4025. |
| `zones` | (int) The zone capacity of your system (6 for Lync 6; 12 for Lync 12). |

## System Entity Capabilities

The Lync system features an integrated MP3 media player that plays audio files from an attach USB device. The following capabilities are made available on the system entity:

| Capability | Description |
| av_transport | Shows MP3 player state, current track name, and artist name as reported by the Lync system. Actions include `play`, `pause`, `stop`. |
| av_repeat | Shows current repeat mode, which can be `all` or `off`; actions facilitate change between states. Shuffle is not available. |
| media_navigation | Makes the `next_track` and `previous_track` actions available. |
| power_switch | `state` attribute will be *true* if any zone is on, *false* if all zones are off. All actions are supported and act on all zones (e.g. `power_switch.on` turns on all zones). |
| toggle | Toggles power state of the system. |
| x_htdlync | Extended capability &mdash; see below. |

The following attributes are implemented for the `x_htdlync` capability on the system entity:

| Attribute | Description |
| mp3_ready | (boolean) *true* if a USB device is connected and the MP3 player is ready; *false* otherwise. |
| reconnects | (int) count of reconnects to the system since startup; if increasing, there's a connectivity problem. |

The following actions are implemented in the `x_htdlync` capability for the system entity:

| Action | Description |
| party_mode | Takes `source`, which can be an integer (1-12 for Lync 6, 1-18 for Lync 12), or the name of the source (must match exactly; case-sensitive). |
| refresh | Causes a refresh of all zones and sources. |
| set_all_volume | Sets the volume on all zones (0.0 to 1.0). |
| set_all_volume_db | Set the volume on all zones in dB; valid (integer) values are -61 (quietest) to 0 (loudest). |

## Zone Entities

*HTDLyncController* manages an entity for each zone. The ID for these entities is the zone number appended to the word `zone` (e.g. `zone1` or `zone11`).

The `media_source` capability allows you to see and set the zone's audio source. The `media_source.selected` attribute will contain the (Lync) source name (user configurable on the Lync system) of the current source. The `media_source.set` action allows you to set the source. You can supply a source index (1-12 for Lync 6, or 1-18 for Lync 12), or a source name (case-sensitive).

The `power_switch` and `toggle` capabilities present and manage the on/off state of the zone.

The `volume` and `muting` capabilities present and manage the volume and muting mode of the zone, respectively. Volume can be set as a percentage (from 0.0 to 1.0) using `volume.set`, or using dB (from -61 to 0) using `volume.set_db`.

The `x_htdlync_zone` extended capability offers additional information from the Lync:

| Attribute | Description |
| balance | (int) Left-right balance level of the zone |
| bass | (int) Bass level of the zone |
| dnd | (boolean) *true* if zone is in Do Not Disturb; *false* otherwise. |
| input | (int) Index (raw) of the current source for this zone (0-11 for Lync 6; 0-17 for Lync 12). |
| keypad | (boolean) *true* if the zone has a keypad. |
| party_mode | (boolean) *true* if the zone is in Party Mode. |
| treble | (int) Treble level of the zone. |
| volume | (int) Volume (dB) reported by the Lync for the zone. |
| zoneid | (int) Lync zone ID. |

## Peculiarities/To-Dos

* The following actions are not yet implemented: DND on/off; set source name; set zone name; set zone balance, treble, bass.
* Lync systems do not have separate *play* and *pause* commands in the serial protocol, and do not report if the media player is playing or paused, so the `av_transport.play` and `av_transport.pause` actions both toggle between play and pause. Because there is no play/pause status indication, *HTDLyncController* infers that the player is active by the name of the current MP3 file changing.

## Support

If you need support, please post in the [Multi-System Reactor category on the Smarthome.Community](https://smarthome.community/category/22/multi-system-reactor). Please be sure to read and follow the [posting guidelines](https://smarthome.community/topic/768/category-topic-guide-read-before-posting).

<small>Updated: 2024-Aug-10</small>
