# MQTTController Change Log

Online docs: https://reactor.toggledbits.com/docs/MQTTController/

**Versions >=24049 require Reactor build 24052 or higher.**

## 25304

**NOTE:** Uses latest `mqtt` package, which is version 5.14.1 as of this writing. You must run `npm run deps` in the *MQTTController* install directory to update the package.

* Ensure template-defined capabilities are properly registered at the system level.
* Fix incorrect response topic when sending the Reactor status in response to query.
* Ensure attribute assignment handles `NaN` illegal value.
* Ensure installed `mqtt` third-party package is up to date at startup.
* In an event response configuration, if an attribute had `json_payload: true` and the payload received was not valid JSON, the entire processing of the event would stop. Other attributes would not be given a chance to interpret the payload. This has been changed so that only the processing of the JSON-seeking attribute is abandoned, and any remaining attributes are procecssed.

## 25139

**NOTE:** Uses latest `mqtt` package, which is version 5.11 as of this writing. You must run `npm run deps` in the *MQTTController* install directory to update the package.

* New template support for Shelly Plus 1PM (use `include: shellyplus1pm`) and Shelly 1 Mini Gen3 (use `include: shelly1minig3`).
* The `query` directive in a device configuration now supports payload construction using the same semantics as that for action payload constructions. Principally, this gives you access to `expr` for query payloads, which facilitates more dynamic construction of payload fields where devices or templates need.
* New inbound topic `reactor/:ident/Reaction/:reaction_id/:command`; the `command` may be `run`, `stop`, or `query` to run (enqueue), stop (if running), or query the status of the specified global or *Ruleset*-based *Reaction*. You cannot run, stop, or query the state of the SET or RESET *Reactions* in a *Rule*. The `query` command requires Reactor build 25111 or higher for accurate response.

## 25090

* Remove support for `uses_template` config directive (deprecated last year); it will be ignored. Use `include` instead.

## 24293

* Lint (code quality) fixes.
* Capability refresh from new Reactor build (requires Reactor 24293).

## 24275

* Compatibility changes for Reactor build 24275 and beyond.

## 24257

* Fix a cosmetic issue in log messages.

## 24162

* Address an issue with action configuration in a template stomping on the action definition in the parent capability.
* Ensure deep copy of template applied to entity.
* Fix an initialization issue when multiple instances of *MQTTController* are configured.

## 24157

* Fix a race condition when loading template definitions from complex directory structures.

## 24155

* Fix an incompatiblity with Reactor builds < 24144; this allows this build of *MQTTController* to be used with `stable` release builds (which tend to be older than `latest`).

## 24144

* Allow templates to define custom extension capabilities (in `capabilities` section at top level of template file).

## 24142

**DEPRECATION NOTICE:** The `uses_template` entity configuration directive is now deprecated; use `include` instead (see below). It will remain functional until build 25091 (Q2 2025).

* PR 0000370: Events for tasmota_generic_relay in template have hard-coded device ID (left over from test/dev).
* System templates are now broken up to multiple files in a hierarchy within the `templates` distribution subdirectory.
* New `include` directive in entity configuration or a template can be used to include the data of another template. You may name a single template (string value), or an array of template names. This permits common behaviors across devices to be modularized in templates. This directive also now replaces `uses_template`, which is deprecated (see above notice).
* The user custom template directory (`config/mqtt_templates/`) now supports any directory hierarchy the user wishes to maintain within it. It searches for templates in YAML or JSON files in the hierarchy, and will traverse ZIP files as well (so template developers can distribute their products in ZIP archives for easy installation/upgrade).

## 24120

* Preserve attribute values if possible when an upgrade to *MQTTController* or system capabilities occurs (soft reconfiguration of entities).

## 24114 (requires Reactor 24108 or higher)

* Add template for Shelly RGBW2 (using Gen1 API) called `shelly_rgbw2_color` (requires `topic`).
* Add support for `wifi_status` capability for some devices; more to come. Previously, those devices stored WiFi status info in `x_mqtt_device` (extended capability) attributes. Now that a first-class capability is being used, **the extended attributes are deprecated and will be removed from a future release.**
* Templates may now remove an action from an entity if it isn't supported by the device. This is done by specifying the action's value as `false`. If a device cannot support any action of a capability, the entire default list of actions for the capability can be removed by specifying the capability value as `false` in the `actions` section of the template. For an example, see the template `shelly_rgbw2_color` implementation for capability `light_effect` action `set_speed`, and the action implementation for the `button` capability.
* Templates may now define custom actions in `x_mqtt_device`. Including an `arguments` object in the standard action arguments format allows the template to notify the UI of the arguments required by the action. For an example, see the template `shelly_rgbw2_color` action `x_mqtt_device.set_white`.

## 24085

* Add template for Shelly H&T Gen 3 called `shelly_handt3` (requires `topic`)

## 24061

* PR 0000365: No really, fix it this time (see 24049, below).
* Enhance Tasmota relay attributes to include device name, IP address, SSID, and RSSI.

## 24050

* Rebuild entity when configuration change detected (supports `version` field in user templates).

## 24049

* PR 0000365: Fix broken config for `tasmota_generic_relay` template's `toggle.toggle` action.
* New templates for *genmon* (generator monitoring; see https://github.com/jgyates/genmon)
* Support for new *js-yaml*
* Support `map` in event handling configuration.

## 23254

* Improve connection recovery time when MQTT broker is still starting up, accepts our connection, but then reports it can't yet process subscription requests (i.e. it's not yet fully ready).

## 23135

* In action payload, fix handling of non-string data type (e.g. boolean, number, etc.) in "raw" form output (convert to string for underlying library &mdash; it does not appear to do that by itself ) when the payload value is derived from an expression (specifically).
* Add `parameter: name` value form to action payload definition to draw payload value from the named parameter without the need to use an `expr`ession (this follows the implementation of action definitions in other *Controller* instances as well).

## 23116

* Provide expression functions `hsltorgb(h,s,l)` and `rgbtohsl(r,g,b)` for conversion between RGB and HSL colors. [[doc](https://reactor.toggledbits.com/docs/MQTTController/)]

## 23010

* Silence a benign warning emitted when *MQTTController* is stopped.

## 22361

* Allow wildcard events in entity configuration. The actual topic received can be accessed in expression context via the `topic` local variable. This is the implementation of Feature Request PR 0000348.

## 22353

* More detailed handling of boolean fields. Where action is concerned, that's actually a fault from the UI (storing string instead of boolean in the reaction), but I can fix that separately and still make it work here, so done.

## 22352

* Make sure all actions defined by a template are registered on the target entity. This allows a template to define an extension action within an existing capability, or, by using `actionname: false` in its `actions` section, declare that the named action is not supported by the device/entity.
* If the `if_expr` or `expr` expressions fail evaluation, also show the payload received with the evaluation error message in the log.

## 22350

* Improve handling of `x_mqtt_device.online` attribute for templates that have custom LWT event.

## 22341

* Polling support. [[docs](https://reactor.toggledbits.com/docs/MQTTController/#polling)]
* Implement `sys_system.restart` action.
* Doc recommendations for publishing templates to the community.

## 22340

* Fix an error in the `x_mqtt_system.publish` action could cause a reaction task to stall.
* The `query` configuration key now takes either a string as a simple topic to be sent with no payload and default QoS/retain, or an object that contains a required key `topic` (string value) and the optional keys `payload`, `qos` and `retain`. These keys have the same meaning as the array entries of `init` (but note that `query` is not an array; only a single topic/payload can be defined). [[docs](https://reactor.toggledbits.com/docs/MQTTController/#additional-entity-configuration)]

## 22337

* New configuration `default_qos` and `default_retain` establish the top of a hierarchy for setting QoS and retain flags. Refer to the [[docs](https://reactor.toggledbits.com/docs/MQTTController/#qos-and-retain)] for details.
* Implement a detection and timeout mechanism for topics sent in QoS 1 and 2 that are never acknowledged. This should really be a function of the underlying *mqtt* package, but for some reason they don't do it. The timeout is 60 seconds, which incorporates sufficient time for several reconnection attempts if the reason for the non-ACK is a broken connection to the broker.
* Templates can now be stored in `mqtt_templates` as YAML files (as before) or (new) ZIP archives containing YAML files. The YAML files can define a single template or multiple.
* Fix docs example in custom template creation.

## 22330

* Improve messages and handling of published topics that aren't acknowledged by the broker.
* Improve docs around custom template creation and use.

## 22326

* Allow templates to be stored in individual files in a `config/mqtt_templates` subdirectory. This should improve users' configuration management for community-contributed templates.
* Additional error checking in install script.

## 22325

* Implement entity deadmarking like other controllers.
* Improve entity initialization/resilience to isolated configuration problems.

## 22324

* Incorporate some device template fixes from @therealdb (with gratitude for his contributions).

## 22323

* Support for deterministic updating of attributes on a topic by using a new/alternate array-based configuration syntax. [[docs](https://reactor.toggledbits.com/docs/MQTTController/#controlling-attribute-evaluation-order)]
* Support for `requires` key in templates to facilitate user-feedback when a template is used but a configuration value required by the template it not provided by the user.

## 22306

* Ease entity ID validation requirements temporarily.

## 22305

* Add methods to allow subscription and publication by other *Controller* instances. [[docs](https://reactor.toggledbits.com/docs/MQTTController/)]

## 22284

**NOTE:** This version requires Reactor version 22280 or higher.

* Add optional default value in topic substitutions. That is, the substitution string `%flavor:chocolate%` would insert the word *chocolate* if *flavor* was not defined in the entity configuration.
* Template `owntracks_in_region` adds a `user` field that can be set if your Owntracks needs it. The Owntracks topic is `/owntracks/user/deviceid`, so the `user` field should be set in your entity configuration (with `topic` and `regionName` to whatever is in that `user` portion of the topic (e.g. if your Owntracks publishes `owntracks/fred/fredsphone` then `topic` should be set to `fredsphone` and `user` should be set to `fred`).
* Code cleanup and sync with Controller base class updates.

## 22260

* Add `owntracks_in_region` template.

## 22150

* Add `tasmota_sensor_flora` template contribution by @Crille

## 22091

* Add hostname to client ID given to the broker -- some brokers (e.g. mosquitto) don't like multiple clients using the same ID, so if we rely only on the controller ID, the user could accidentally create a collision (controller ID is determined by the user config). Adding the hostname should avoid that in most cases. Where it doesn't/can't, the `clientId` can be set in `config.options` for the broker conneection.

## 22086

* Improve excessive-retry detection with mqtt package.

## 22081

* Improve echo config handling for rule states and global variables.
* Trap errors on regular expressions in config and report to log (i.e. don't crash if user enters a bad regexp).

## 22029

* Echo function now publishes rule states and global variable values. Please see the docs linked at top for more details.

## 22024

* Fix command case for Tasmota generic relay (some firmware complains if its not all uppercase)

## 22009

* Allow `entity_identifier` to be set to `id/name` (which is a synonym for `combined`), or `name/id`, the order of the levels being as indicated.

## 22008

* Users may now add the entity name to echo telemetry topics via the `entity_identifier` configuration key (`echo` section); please refer to the documentation for details.

## 21361

* PR 0000280: Fix error thrown on perform when 'entities' key missing from config entirely.

## 21355

* System alerts are now published via `reactor/<controller-id>/alerts`

## 21343

* Add `include_groups` and `exclude_groups` filters for echo selection.
* Default `exclude_capabilities` when *not defined* will filter out extension capabilities.
* Docs updates and fixes.

## 21331

* Detect stalled connections on reconnect (openLuup) and hard-close/recycle. Note that openLuup is not supported as a "production" broker because it does not fully implement the MQTT 3.1.1 standard/requirements.
* More carefully guard sensors (in templates) from payloads that don't contain the sensor data (i.e. avoid setting null value if an update is published with data missing).
* Additional templates for Tasmota and Shelly.
* Documentation updates and clarifications.

## 21321

* Fix incorrect scope reference in *tasmota_generic_relay* payload.
* Additional helpful debug.

## 21320

* The `init` section for device initializations (optional) has been added; refer to the docs.
* The `x_mqtt_device.poll` action is now defined for devices with `query` configured; refer to the docs.
* Allow `username` and `password` in controller config for authentication.

## 21319

* Initial release version; reports at 21313
