# ZWaveJSController Change Log

**BREAKING CHANGE WARNING:** If you are upgrading from a build earlier than 24242: the entity IDs of certain child entities may change to reflect a more deterministic naming style. Entities principally effected would be those created in 2022 and earlier for scene activation. Rules that use these entities will need to be updated. You will only need to do this once.

## 25304

* Update device-specific handler for Leviton VRCS1 single-button scene controller.

## 25139

* Minor bug fixes in initialization of some devices with scene controller capabilities.

## 25082

**This build of *ZWaveJSController* requires Reactor build 25082 or higher.**

**BREAKING CHANGE:** For RGBW/RGBWW devices, the `color_temperature` capability is no longer used; white channels will now be mapped to the `dimming` capability. If you have such devices and use `color_temperature` attributes and actions, you will need to make appropriate adjustments to your *Rules* and *Reactions*.

* Add support for start and stop heal actions (in `zwave_network` capability).
* Improve connection retry decay computation (use slow initial decay with rapid ramp).
* Improve handling of white channels in RGBW/RGBWW devices. Mapping them to `color_temperature` seems to be incorrect in most cases, so they are now mapped to `dimming`. If the device has multiple channels, the white or color channels may be pushed to child entities.
* The `zwave_device.set_value` action now accepts JSON in the value fields for Z-Wave JS values that support it. Some devices are able to report or set multiple values simultaneously by using a dictionary as the value (aka JSON object with key/value pairs). RGBWW devices, for example, may support the `currentColor` and `targetColor` property with a value object like `{ "warmWhite": 0, "coldWhite": 0, "red": 128, "green": 0, "blue": 240 }`.

## 24293

* Use new capability refresh tools in *Controller* base class (requires Reactor build 24293 or higher).
* Use system-default actions for many where the local implementation was basically the same (e.g. `dimming.up/down`).
* Fixes for TILTZWAVE2.5-ECO
* Fix Binary Sensor smoke detector handling
* Code improvements and cleanups, tweaks for new info from *Z-Wave JS*.

## 24257

* Fix an issue with polling rescheduling that can cause polling to take too long to re-poll a node after the initial poll.
* Handle forced-write of attributes when processing events for the Notification Command Class.

## 24242

* Handle notification special events (in Notification CC 113 type 6) for locks for better performance of `keypad` capability attributes (where the device and *Z-Wave JS* support it).
* Update Fibaro FGR222/FGRM222 handling for manufacturer proprietary venetian blind position and tilt
* Creation of child entities is expanded to include all command classes that result in capability/attribute collisions on an entity. That is, if two or more values (from Z-Wave JS) on an endpoint resolve to the same Reactor capability, a new child entity is created.

## 24232

* Fix actions that control multiple endpoints (e.g. controlling one outlet of a multi-outlet device).
* Device configuration improvements and minor bug fixes.
* Sync/certify to zwavejs driver 13.1.0

## 24024

* Fix an error thrown while attempting to set associations on some older scene controllers.
* Add `x_zwavejs_ctrl.add_assocation` action (on system entity).
* Fix "node no longer exists" message error.

## 23326

**BREAKING CHANGE WARNING:** See change for `hvac_control.state` below.

* Fix Multilevel Switch CC without Binary Switch CC mapping for `power_switch` and `dimming` capabilities.
* Support more variants of Window Covering command class 106. Move support for iBlinds v3 using Window Covering CC to generic support.
* Values for `hvac_control.state` did not match the specification for the capability and attribute; they have been modified (e.g. was `cool` now `cooling`, was `heat` now `heating`). This is a potentially breaking change for users with conditions on this attribute.

## 23254

* Some versions of iBlinds v3 report CC 38 (Multilevel Switch) and some report 106 (Window Covering), no obvious way to tell if there's a config parameter that controls this, or if it's a firmware change (firmware versions report same even when command class is different). Update handles both based on what's available (this is the first time I've seen a 106-reporter in the wild).

## 23194

**NOTE:** This version requires schema 25 or higher *ZWaveJS*. Make sure you upgrade your `zwavejs-ui` or `zwave-js-server` before upgrading to this version of *ZWaveJSController*.

* Support ZWaveJS `ping` command/action.
* Version 1.25 (schema 25) of ZWaveJS is now required.

## 23093

* Fix iBlinds V3 (mfg 647) `cover.state` expression.

## 23063

* Command class `Sound Switch` now maps to `chime` capability (Aeotec Siren 6, others)
* Support multi-step action implementations (e.g. `chime.play` needs to set two values sequentially (volume then sound).

## 23011

* Specific support for iblinds V3 (mfg 647);

## 23010

* Fix a possible runtime error during node configuration if the target node isn't yet fully ready.

## 22323

**NOTE:** This version requires Reactor build 22314 or higher.

* Allow `zwave_device.set_config` parameter to be either string (property name) or number (property/configuration parameter ID). This should improve usability for this action.
* Store property ID in metadata for `x_zwave_values` attributes.
* Improve "first guess" device support for many devices when Z-Wave JS is still running interviews and Reactor comes up (i.e. when data from Z-Wave JS about devices is incomplete).
* Improve device support for multiple Fibaro, Aeotec, Everspring devices.
* Improve manufacturer/device support for Remotec, Poly-Control, Danalock, Zipato, Nortek, NEO, Minoston (EVA Logik).

## 22305

* Package file update (cosmetic only).

## 22302

* Info logging of actions (like other Controllers)

## 22283

**NOTE:** This version requires Reactor version 22280 or higher.

* Code cleanup and sync with Controller base class updates.

## 22256

* Send notice upon discovery of new node (like other Reactor controllers).
