/** input-autogrow jQuery plugin originally by westonganger
 *  https://github.com/westonganger/input-autogrow
 *  https://www.jqueryscript.net/form/jQuery-Auto-Grow-Plugin-For-Input-Fields-input-autogrow.html
 *
 *  Modified by Patrick Rigney (toggledbits) for Reactor/MSR:
 *     * More dynamic max width in case <input> not appended to DOM (so no default sizes) when plugin started.
 *     * Add autogrow class to controlled input elements to make them easy to identify.
 *     * If input is empty string (not just null) use placeholder for width computation.
 *     * Size accommodation for datalist controls.
 *     * ES11-ized
 *
 *  Reactor-ized version 24287
 */

(function($){
  const events = (('oninput' in document.createElement('input')) ? 'input' : 'keydown') + '.autogrow change.autogrow autogrow';

  const isObject = function(x){
    return x === Object(x);
  };

  $.fn.inputAutogrow = function(options){
    if (options === 'destroy'){
      this.each( ( ix, el ) => {
        if( $( el ).data( 'autogrow-span' ) ){
          const input = $( el );

          input.off(events);

          const span = input.data("autogrow-span");
          span.remove();
          input.data('autogrow-span','');

          input.data('original-width','');
        }
      });

      return this;
    }

    this.each( ( ix, el ) => {
      const input = $( el );
      let minWidth;

      if(input.data('original-width')){
        minWidth = input.data('original-width');
      }else{
        minWidth = input.width();
        input.data('original-width', minWidth);
      }

      let opts = { maxWidth: 0, minWidth: minWidth, trailingSpace: 0 };

      if(options && isObject(options)){
        opts = $.extend(opts, options);
      }

      let val = null;

      const span = $('<span/>').css({
        position: 'absolute',
        top: -9999,
        left: -9999,
        width: 'auto',
        fontSize: input.css('fontSize'),
        fontFamily: input.css('fontFamily'),
        fontWeight: input.css('fontWeight'),
        letterSpacing: input.css('letterSpacing'),
        textTransform: input.css('textTransform'),
        whiteSpace: 'nowrap',
        ariaHidden: true
      }).appendTo('body');

      const check = function(e){
        if(val === (val = input.val()) && e.type !== 'autogrow'){
          return;
        }

        if ( "" === ( val || "" ) ){
          val = input.attr('placeholder') || '';
        }

        span.html(val.replace(/&/g, '&amp;').replace(/\s/g, '&nbsp;').replace(/</g, '&lt;').replace(/>/g, '&gt;'));

        let newWidth = span.width() + parseInt(input.css('fontSize')) * opts.trailingSpace;
        let mw = typeof(opts.maxWidth) === "function" ? opts.maxWidth() : opts.maxWidth;

        if ( ! mw ) {
            mw = input.parent().innerWidth();  /* Current width of parent element */
        }

        if ( newWidth > mw ) {
          newWidth = mw;
        } else if ( newWidth < opts.minWidth ) {
          newWidth = opts.minWidth;
        }

        /* Datalists need extra room for controls */
        if ( input.attr( 'list' ) ) {
            newWidth = Math.max( 96, newWidth + 32 );
        }

        if(newWidth !== input.width()){
          input.width(newWidth);
        }
      };

      input.data("autogrow-span", span);
      input.off(events).on(events, check);
      input.removeClass( "w-100").addClass( "autogrow" ); /* PHR make easy to find */

      check(); //init on page load
    });

    return this;
  };
}(window.jQuery || window.Zepto || window.$));
