//# sourceURL=widgets/Level.js
// Version 24344

import Widget from '../Widget.js';

var Level = function( elem ) {
    Widget.call( this, elem );
    this.name = "Level";
    this.entity_id = this.getData( 'light', this.entity_id );  // special override
    this.level_expr = this.getData( 'level', 'entity.attributes.dimming.level' );
    this.level_value = 0;
    this.lastLevel = -1;
    this.ignoreNextClick = false;

    $(this.elem).addClass("widget-level");
};

Level.prototype = Object.create(Widget.prototype);
Level.prototype.constructor = Level;

Level.prototype.layoutInit = function( layoutName, descObj ) {
    var self = this;

    // We have layout-specific implementation
    if ( "slider" === layoutName ) {
        $('div#slider', this.elem).slider({
              "min" : 0
            , "max" : 100
            , "step" : parseInt( this.getData("step", 5) )
            , "value" : 0
            , "stop": function( e, ui ) {
                e.preventDefault();
                e.stopPropagation();
                self.ignoreNextClick = true; // blech
                // self.log.debug( 5, "slider changed to " + ui.value + " by " + ui.handle);
                self.setLevel( ui.value );
                return false;
            }
            , "change": function( e, ui ) {
                e.preventDefault();
                e.stopPropagation();
                $( 'div.widget-value', self.elem ).text( ui.value );
                return false;
            }
        });
    } else if ( "gauge" === layoutName ) {
        $('.dial', self.elem).Knob({
               release: function( val ) { self.ignoreNextClick = true; self.setLevel( val ); }
        });
    }
};

Level.prototype.doDimmingUp = function( act, ev ) {
    console.warn("DEPRECATED Level.doDimmingUp()");
    this.performOnEntity( null, 'dimming.up', { } );
    return false;
};

Level.prototype.doDimmingDown = function( act, ev ) {
    console.warn("DEPRECATED Level.doDimmingDown()");
    this.performOnEntity( null, 'dimming.down', { } );
    return false;
};

Level.prototype.doIncrement = function( act, ev ) {
    console.log( act, ev );
    ev.stopPropagation();
    let level = parseFloat( $( 'div.levelvalue', this.elem ).text() );
    const step = this.getData( "step", 1.0 );
    console.log("level value=", typeof level, level, "step=", typeof step, step);
    if ( ! ( isNaN( level ) || isNaN( step ) ) ) {
        level += step;
        let max = this.getData( "max", false );
        if ( false !== max && ! isNaN( max ) && level > max ) {
            level = max;
        }
        const prec = this.getData( "prec", 0 );
        level = Math.round( level * Math.pow( 10, prec ) ) / Math.pow( 10, prec );

        $(this.elem).addClass("update-pending");

        const action = this.getData( 'change-action' );
        const p = {};
        p[ this.getData( 'change-action-param' ) ] = level;
        console.log( "Level.doIncrement action", action, "params", p );
        this.performOnEntity( null, action, p );
    }
};

Level.prototype.doDecrement = function( act, ev ) {
    ev.stopPropagation();
    let level = parseFloat( $( 'div.levelvalue', this.elem ).text() );
    const step = this.getData( "step", 1.0 );
    console.log("level value=", typeof level, level, "step=", typeof step, step);
    if ( ! ( isNaN( level ) || isNaN( step ) ) ) {
        level -= step;
        let min = this.getData( "min", false );
        if ( false !== min && ! isNaN( min ) && level < min ) {
            level = min;
        }
        const prec = this.getData( "prec", 0 );
        level = Math.round( level * Math.pow( 10, prec ) ) / Math.pow( 10, prec );

        $(this.elem).addClass("update-pending");

        const action = this.getData( 'change-action' );
        const p = {};
        p[ this.getData( 'change-action-param' ) ] = level;
        console.log( "Level.doIncrement action", action, "params", p );
        this.performOnEntity( null, action, p );
    }
};

Level.prototype.doActionOn = function( act, ev ) {
    if ( this.entity.hasCapability( "power_switch" ) ) {
        this.performOnEntity( null, 'power_switch.on' );
        return false;
    }
};

Level.prototype.doActionOff = function( act, ev ) {
    if ( this.entity.hasCapability( "power_switch" ) ) {
        this.performOnEntity( null, 'power_switch.off' );
        return false;
    }
};

Level.prototype.post_update = function() {
    var newVal = parseInt( $('.widget-value', this.elem).text() );
    if ( this.layout == "slider" ) {
        $('div#slider', this.elem).slider( 'value', newVal );
    } else if ( this.layout == "gauge" ) {
        $('input.dial', this.elem).val( newVal ).trigger( 'change' );
    } else {
        // nothing to do here because default layout should use binding
    }
};

Level.prototype.setLevel = function( level ) {
    if ( ! this.entity ) {
        this.log.debug( 3, "setLevel() can't, entity not yet bound" );
        return;
    }
    if (level < 0) level = 0; else if (level > 100) level = 100;
    // PHR??? Figure out why knob step isn't doing this for us
    this.log.debug( 4, "sending level %1 to controller for light %2", level, this.entity );
    $(this.elem).addClass("update-pending");
    if ( this.entity.getType() !== "Light" || level == 0 ) {
        /* Not a dimmer, or zero level, use setState */
        this.performOnEntity( null, "power_switch." + ( level > 0 ? "on" : "off" ) );
    } else {
        /* Dimming level for Light (dimmer class) */
        this.performOnEntity( null, "dimming.set", { "level": level / 100.0 } );
    }
};

export default Level;
