/** jQuery-ComboBox
 *  Patrick Rigney https://www.toggledbits.com/
 *  An adaptation of http://loyc.net/2018/mostly-css-combo-boxes.html
 *  (made into a jQuery plugin)
 *
 *  Usage: $( '<input type="text">' ).combobox();
 *         That is, an <input> is converted to a combobox by this plugin.
 */

/* eslint vars-on-top: "off" */

( function ( $ ) {

    $.fn.combobox = function( options ) {
        this.each( function() {
            var settings = $.extend({
                /* Defaults */
            }, options );

            var $f = $( this );

            /* Remove Bootstrap formatting, then wrap */
            $f.removeClass( 'form-control form-control-sm form-control-lg' )
                .wrap( '<span class="combobox"></span>' );
            var $combo = $f.parent();
            $( '<span class="downarrow" tabindex="-1"></span>' ).appendTo( $combo );
            $( '<select tabindex="-1"></select>' )
                .change( function() {
                    var $textbox = $f.closest( '.combobox' ).children( 'input' );
                    $textbox.val( $f.val() );
                    $( this ).parent().children( 'input' ).focus();
                } )
                .keypress( function( e ) {
                    if ( 13 === e.keyCode ) {
                        $( this ).parent().children( 'input' ).focus();
                    }
                } )
                .attr( 'size', settings.size || 5 )
                .appendTo( $combo );
        });
        return this;
    };

}( jQuery ) );
