//# sourceURL=Logger.js

var Logger = function( ident ) {
    this.ident = ident;
    this.level = 4;
    this.writer = Logger._defaultwriter;
};

Logger.prototype.constructor = Logger;

Logger.CRIT = 0;
Logger.ERROR = Logger.ERR = 1;
Logger.WARN = Logger.WARNING = 2;
Logger.NOTICE = 3;
Logger.INFO = 4;
Logger.DEBUG0 = 5;
Logger.DEBUG1 = 6;
Logger.DEBUG2 = 7;
Logger.DEBUG3 = 8;
Logger.DEBUG4 = 9;

Logger.instances = [];

Logger.getLogger = function( ident, parent ) {
    if ( Logger.instances[ident] )
        return Logger.instances[ident];
    var l = new Logger( ident );
    l.parent = ( undefined === parent ) ? false : parent;
    Logger.instances[ident] = l;
    return l;
};

Logger.getDefaultLogger = function() {
    return Logger.getLogger("default");
};

Logger._defaultwriter = function( level, msg ) {
    var f = console.log;
    if ( level < 2 )
        f = console.error || console.log;
    f(msg);
};

Logger.prototype.setWriter = function( f ) {
    this.writer = f;
};

Logger.prototype.setLevel = function( level ) {
    var oldLevel = level;
    this.level = level;
    return oldLevel;
};

Logger.prototype.getLevel = function() {
    return this.level;
};

Logger._fill = function( n, l, p ) {
    p = p || "0";
    var s = String( n );
    while ( s.length < l ) {
        s = p + s;
    }
    return s;
};

Logger.prototype._emit = function( level, msg ) {
    if ( level <= this.level ) {
        var args = Array.prototype.slice.call(arguments, 2);
        var str = msg.replace(/%([0-9]+|%)/g, function( match, p1 ) {
            if ( p1 == '%' ) return "%";
            p1 = parseInt(p1);
            if ( p1 < 1 || p1 > args.length ) return "[undefined" + p1 + "]";
            var val = args[p1-1];
            return String(val);
        });
        var now = new Date();
        var s = Logger._fill( now.getFullYear(), 4 ) + '-' +
            Logger._fill( now.getMonth() + 1, 2 ) + '-' +
            Logger._fill( now.getDate(), 2 ) + '.' +
            Logger._fill( now.getHours(), 2 ) + ':' +
            Logger._fill( now.getMinutes(), 2 ) + ':' +
            Logger._fill( now.getSeconds(), 2 ) + '.' +
            Logger._fill( now.getMilliseconds(), 3 );
        this.writer(level, s + ' <' + this.ident + ":" + level + '> ' + str );
    } else if ( this.parent ) {
        /* Our log level doesn't want to log this; pass to parent to see if they will */
        this.parent._emit.apply( this.parent, Array.prototype.slice.call(arguments, 0) );
    }
};

Logger.prototype.crit = function( msg ) {
    var args = Array.prototype.slice.call(arguments, 0);
    args.unshift(Logger.CRIT);
    this._emit.apply( this, args );
};

Logger.prototype.err = function( msg ) {
    var args = Array.prototype.slice.call(arguments, 0);
    args.unshift(Logger.ERR);
    this._emit.apply( this, args );
};

Logger.prototype.error = Logger.prototype.err; /* synonym */

Logger.prototype.warn = function( msg ) {
    var args = Array.prototype.slice.call(arguments, 0);
    args.unshift(Logger.WARN);
    this._emit.apply( this, args );
};

Logger.prototype.warning = Logger.prototype.warn; /* synonym */

Logger.prototype.notice = function( msg ) {
    var args = Array.prototype.slice.call(arguments, 0);
    args.unshift(Logger.NOTICE);
    this._emit.apply( this, args );
};

Logger.prototype.info = function( msg ) {
    var args = Array.prototype.slice.call(arguments, 0);
    args.unshift(Logger.INFO);
    this._emit.apply( this, args );
};

Logger.prototype.log = Logger.prototype.info; /* synonym */

Logger.prototype.debug = function( level, msg ) {
    if ( level <= this.level ) {
        var args = Array.prototype.slice.call(arguments, 0);
        this._emit.apply( this, args );
    } else if ( this.parent ) {
        this.parent._emit.apply( this.parent, Array.prototype.slice.call(arguments, 0) );
    }
};

Logger.prototype.exception = function( ex ) {
    console.log( ex ); /* ??? Temporary brute-force */
};

Logger.prototype.deprecated = function( obj, item ) {
    this.warn( String(obj) + " uses deprecated " + item );
};

export default Logger;