//# sourceURL=widgets/RSSFeed.js
/**
 * $Id: RSSFeed.js 303 2018-11-25 22:41:49Z patrick $
 */
/* globals define,SlapDash */

define( [ 'Widget'], function( Widget ) {

    const RSSFeed = function( elem ) {
        Widget.call( this, elem );
        this.name = "RSSFeed";
        this.id = $(this.elem).data('id');
        this.feed = $(this.elem).data('feed');
        this.delay = $(this.elem).data('delay');
        if (typeof this.delay == "undefined") this.delay = 3600;
        this.maxtitle = $(this.elem).data('headline-max');
        if (typeof this.maxtitle == "undefined") this.maxtitle = 0;
        this.nextEntry = 0;
        this.currentLink = "#";
        this.intervalID = undefined;
        this.scrollPos = 0;
        this.paused = false;
        $(this.elem).addClass("widget-rssfeed");
        // this.log.info("RSSFeed constructed");
    };

    RSSFeed.prototype = Object.create(Widget.prototype);
    RSSFeed.prototype.constructor = RSSFeed;

    RSSFeed.prototype.start = function() {
        var self = this;
        // this.log.info("RSSFeed start");
        $(this.elem).html('<h1></h1><div id="wrapper" style="width: 96% !important; height: 100% !important; overflow: hidden;"><div id="content"></div></div>');
        $('h1', this.elem).text( this.getData( 'title', '' ) );

        $(this.elem).mouseenter( function() { self.paused = true; } );
        $(this.elem).mouseleave( function() { self.paused = false; } );

        this.localUpdate();

        this.intervalID = setInterval( function() { self.localUpdate(); }, self.delay * 1000 );
    };

    /* This is a hack. We use localUpdate() rather than update because we don't
       have a time-based controller, so the default controller (Hass or Vera) is
       sending updates every time it gets one from the underlying system. We need
       to add something like TimeController, for widgets like this and Clock that
       aren't based on an underlying subsystem, but just do time-based updating.
       PHR??? 2018-03-25 TickController ??? */
    RSSFeed.prototype.localUpdate = function() {
        console.log("Handling localUpdate() for RSSFeed");
        const self = this;
        if (this.getData('display', 'default') === 'marquee') {
            if (typeof this.intervalID != "undefined") clearInterval( this.intervalID );
            $.getJSON(SlapDash.config.baseurl + '/api/rssproxy', { 'url' : self.feed, 'all' : 1 },
                function( data, status ) {
                    let txt = '';
                    self.log.debug(4, 'news feed returned ' + data.stories.length);
                    for (let ix=0; ix<data.stories.length; ++ix) {
                        txt += '<p><a href="' + data.stories[ix].link + '">' + data.stories[ix].title + '</a></p>';
                    }
                    // self.log.debug(4, 'txt is ' + txt);
                    $('div#content', self.elem).html(txt);
                    $('h1', self.elem).text( self.getData( 'title', data.feedtitle ) );
                    $(self.elem).removeClass("nodata update-pending active");
                }
            );
            $('div#content').get(0).style.marginTop = this.scrollPos = 0;
            this.intervalID = setInterval( function() { self.animate(); }, 100 );
        } else {
            $.getJSON("Xjax/getrssfeed.php", { "url" : self.feed, "entry" : self.nextEntry },
                function( data, status ) {
                    if (data.status == 200) {
                        self.nextEntry = data.nextentry;
                        let t = data.title;
                        if (self.maxtitle && t.length > self.maxtitle) t = t.substr(0, self.maxtitle) + '...';
                        let txt = '<img src="' + data.feedimage + '"><p>' + t + "</p>";
                        self.currentLink = data.link;
                        $(self.elem).html(txt);
                        $('h1', self.elem).text( self.getData( 'title', data.feedtitle ) );
                        $(self.elem).removeClass("nodata update-pending active");
                    } else {
                        const msg = data.message;
                        $(self.elem).html('<p>No Data for ' + self.feed + '<br/>' + (typeof msg == "undefined" ? "" : msg) + '</p>');
                        self.currentLink = "#";
                        self.nextEntry = 0;
                        $(self.elem).removeClass("update-pending active").addClass("nodata");
                    }
                }
            );
        }
    };

    RSSFeed.prototype.click = function() {
        this.log.debug(4, "RSSFeed click handler going to " + this.currentLink);
        if (typeof this.currentLink != "undefined" && this.currentLink.length > 0)
            window.open( this.currentLink, '_blank' );
    };

    RSSFeed.prototype.close = function() {
          clearInterval( this.intervalID );
    };

    RSSFeed.prototype.animate = function() {
        if (this.paused) return;
        const content = $('div#content', this.elem);
        let hgt = $(content).height();
        //this.log.debug(4, "height=" + hgt + ", scrollpos=" + this.scrollPos);
        this.scrollPos -= 2;
        if ( (-this.scrollPos) > hgt) {
            this.scrollPos = $(content).parent().height();
        }
        $(content).get(0).style.marginTop = this.scrollPos;
    };

    return RSSFeed;

}); // define
