//# sourceURL=widgets/RoomStatus.js
/**
 * $Id: RoomStatus.js 303 2018-11-25 22:41:49Z patrick $
 */
/* global SlapDash */

import Widget from '../Widget.js';
import Group from "/client/Group.js";
import * as util from '/client/util.js';

var RoomStatus = function( elem ) {
    Widget.call( this, elem );
    this.name = "RoomStatus";
    this.entity_id = this.getData( 'select', "" );
    this.roomTitle = this.getData( 'title' );
    this.showSystem = this.getDataBool( 'showsystem', true );

    $(this.elem).addClass("widget-roomstatus");
};

RoomStatus.prototype = Object.create(Widget.prototype);
RoomStatus.prototype.constructor = RoomStatus;

RoomStatus.prototype.pre_update = function() {
    let entities = [];
    if ( this.entity && this.entity instanceof Group ) {
        entities = this.entity.listMembers();
    }

    let devices = [];

    let selected = {};
    entities.forEach( function( eid ) {
        const e = SlapDash.findEntity( eid );
        if ( e ) {
            selected[e.getName()] = e;
        }
    });
    const keys = util.sortByKey( selected );
    const nk = keys.length;
    for (let ix=0; ix<nk; ++ix) {
        const e = selected[keys[ix]];
        if ( e.getType() === "Script" ) continue;
        try {
            if ( e.getPrimaryValue() ) {
                let stat = e.getName();
                if ( e.hasCapability( "dimming" ) ) {
                    stat += " (" + e.getAttribute("dimming.level") + "%)";
                }
                devices.push( stat );
            }
        } catch( ex ) {
            util.debug(9, "Can't convert state for", String(e), "to boolean, skipping.", String(ex));
        }
    }
    if ( devices.length === 0 ) {
        devices.push("No displayable devices");
    }

    this._ctx.devices = devices;
//devices.push(navigator.userAgent);
//devices.push("Default font size " + $('body').css('font-size'));
};

export default RoomStatus;