//# sourceURL=jobs/CameraController.js
/**
 * $Id: Controller.js 279 2017-10-28 22:33:19Z patrick $
 */
/* globals define,Promise,CameraController */

define( [ 'Controller', 'util' ], function( Controller, util ) {

    CameraController = function( source ) {
        Controller.call( this, source );
        if ( "default" !== this.unit ) {
            this.baseurl = document.location.protocol + '//' + this.unit;
        } else {
            this.baseurl = SlapDash.config.baseurl;
        }
        console.log("camera baseurl is "+this.baseurl+" for unit "+this.unit);
    };

    CameraController.prototype = Object.create(Controller.prototype);
    CameraController.prototype.constructor = CameraController;

    CameraController.prototype.start = function() {
        var self = this;
        return new Promise( function( resolve, reject ) {
            self.run();
            resolve( self );
        });
    };

    CameraController.prototype.run = function() {
        /* We do nothing -- the widgets handle their own timing and updates. */
        this.system.setAttributes( { state:true, error:false, lastupdate:0 } );
    };

    CameraController.prototype.getSnapshotURL = function( camera, moreArgs ) {
        var s = this.baseurl + "/api/camera/" + camera.getId();
        if ( moreArgs ) {
            s += '?';
            for ( var key in moreArgs ) {
                s += encodeURIComponent(key);
                s += "=";
                s += encodeURIComponent(String(moreArgs[key]));
                s += "&";
            }
        }
        return s;
    };

    return CameraController;

}); // define
