//# sourceURL=main.js
/**
 * Version 25080
 */

/*

requirejs.config({
  urlArgs: "bust=" + (new Date()).getTime(),
  paths: {
    "jQuery": "node_modules/jquery/dist/jquery.min",
    "jQuery-ui": "node_modules/jquery/dist/jquery-ui.min",
    "jQuery-knob": "node_modules/jquery/dist/jquery-ui.min",
    "jQuery-gridster": "lib/js/jQuery.gridster"
  },
});
*/
/*
requirejs.onError = function( err ) {
    console.log(err.requireType);
    if (true || err.requireType == 'timeout') {
        console.log('modules: ' + err.requireModules);
    }
    console.log(String(err));
    if (err.stack) console.log(err.stack);
    throw err;
};
*/

import SlapDash from './SlapDash.js';

window.SlapDash = SlapDash;

const scripts = [
    '/dashboard/slapdash/node_modules/jquery/dist/jquery.min.js',
    '/dashboard/slapdash/node_modules/jquery-ui/dist/jquery-ui.min.js',
    "/dashboard/slapdash/node_modules/dsmorse-gridster/dist/jquery.dsmorse-gridster.min.js",
    // "/dashboard/slapdash/node_modules/knob/index.js",
    "/dashboard/slapdash/node_modules/js-yaml/dist/js-yaml.min.js"
];

const head = document.getElementsByTagName('head')[0];
const linkstyles = function( url ) {
    var styles = document.createElement( 'link' );
    styles.rel = 'stylesheet';
    styles.type = 'text/css';
    styles.href = url;
    head.appendChild( styles );
};
linkstyles( "/dashboard/slapdash/node_modules/jquery-ui/dist/themes/smoothness/jquery-ui.min.css" );
linkstyles( "/dashboard/slapdash/node_modules/dsmorse-gridster/dist/jquery.dsmorse-gridster.min.css" );
linkstyles( "/dashboard/slapdash/node_modules/@fontsource/open-sans/index.css" );
linkstyles( "/dashboard/slapdash/node_modules/bootstrap-icons/font/bootstrap-icons.css" );

const loadScript = function( url ) {
    return new Promise( function( resolve ) {
        var script = document.createElement( 'script' );
        script.type = 'text/javascript';
        script.src = url;
        script.onload = () => {
            console.log("Loaded", url);
            resolve( url );
        }
        head.appendChild( script );
    });
};

let lastScript = 0;
const nextScript = function() {
    if ( lastScript < scripts.length ) {
        loadScript( scripts[ lastScript++ ] ).then( () => {
            nextScript();
        });
    } else {
        /* Wait for jQuery */
        jQuery( function() {
            /* Finished loading. Wait for config. */
            console.log("jQuery ready, waiting for config to load...");
            SlapDash.getAllConfig().catch( function() {} ).finally( function() {
                console.log("Config final; here we go...");
                SlapDash.start( $( 'div.dashboard' ) );
            });

            window.setTimeout( function() { location.reload( true ); }, 86400000 ); /* daily forced reload */
        } );
    }
};
nextScript();
