//# sourceURL=widgets/MediaPlayer.js
/**
 * $Id: MediaPlayer.js 287 2018-03-05 20:28:44Z patrick $
 */

import Widget from '../Widget.js';

var MediaPlayer = function( elem ) {
    Widget.call( this, elem );
    this.name = "MediaPlayer";
    this.lastMediaPlayer = -1;
    this.ignoreNextClick = false;

    $(this.elem).addClass("widget-mediaplayer");
};

MediaPlayer.prototype = Object.create(Widget.prototype);
MediaPlayer.prototype.constructor = MediaPlayer;

MediaPlayer.prototype.doActionNext = function( ev ) {
    if ( this.entity ) {
        this.entity.doAction( 'mediaplayer_next' );
    }
};

MediaPlayer.prototype.doActionPrev = function( ev ) {
    if ( this.entity ) {
        this.entity.doAction( 'mediaplayer_prev' );
    }
};

MediaPlayer.prototype.doActionPlay = function( ev ) {
    if ( this.entity ) {
        this.entity.doAction( 'mediaplayer_play' );
    }
};

MediaPlayer.prototype.doActionPause = function( ev ) {
    if ( this.entity ) {
        this.entity.doAction( 'mediaplayer_pause' );
    }
};

MediaPlayer.prototype.doActionStop = function( ev ) {
    if ( this.entity ) {
        this.entity.doAction( 'mediaplayer_stop' );
    }
};

// Implement the disable() method so that we can clear our resident data if no
// data is available from the controller for the device. This fixes the bug where
// lights aren't marked active after a controller reset (because we have a local copy
// of the previous light MediaPlayer we use to determine if most of the update work should
// be done.
MediaPlayer.prototype.disable = function() {
};

MediaPlayer.prototype.post_update = function() {
    const e = this.entity;
    if ( ! e ) return;

    const st = e.getAttribute("av_transport.state", "STOPPED").toLowerCase();
    const art = e.getAttribute("av_transport.album_art", "");
    if ( "stopped" !== st && "" !== art ) {
        this.elem.css("background-image", "url('" + art + "')")
            .css("background-repeat", "no-repeat")
            .css("background-position", "center")
            .css("background-size", "cover");
    } else {
        $(this.elem).css("background-image", "");
    }
};

MediaPlayer.prototype.click = function( ev ) {
    this.log.debug(4, "Handling click on " + ev.currentTarget);
    if ( this.ignoreNextClick ) {
        this.ignoreNextClick = false;
        return false;
    }

    return true;
};

export default MediaPlayer;
