#!/usr/bin/env sh
#
# This file is part of Reactor. https://reactor.toggledbits.com/docs/
#
# Probe WAN access and set a boolean on the system entity indicating its health.
# This is done by pinging a remote site from a set of possibilities. One site
# from the list is probed each time this script is run. If three consecutive
# probes (by default) fail, mark the internet down by setting the attribute on
# the system entity to false.
#
# Version 24103
#
# IMPORTANT! Ideally, DON'T MODIFY THIS SCRIPT WITH YOUR CONFIGURATION CHANGES.
# Copy the "reactor_inet_check.cf-dist" file into your config directory as
# "reactor_inet_check.cf" and customize the contents of that file.
#
# The script must be run from the Reactor home directory (the Reactor home
# directory must be the current directory when the script is started).
#
#     cd /path/to/reactor
#     tools/reactor_inet_check.sh
#
# RECOMMENDED: RUN THIS SCRIPT UNDER CRON
# It is recommended that you run this script from the crontab of your Reactor
# user. Use the `crontab -e` command to edit the crontab while logged in as
# that user. The following line add to your crontab will run the script every
# minute (refer to crontab(5) for other timing):
# * * * * * cd /path/to/reactor && tools/reactor_inet_check.sh
#
# ------------------------------------------------------------------------------

# If you have a long-lived access token (LLAT), put it between quotes below.
LLAT=""

RH=${REACTOR_HOME:-`pwd`}
RD=${REACTOR_DATA_PREFIX:-.}

[ -d ${RD}/config -a -d ${RH}/storage ] || {
    echo "Can't find 'config' and 'storage' directories in ${RH}";
    echo "This script must be run from the Reactor install directory. Example:";
    echo "    cd /home/pi/reactor"
    echo "    tools/reactor_inet_check.sh"
    echo " "
    echo "Recommended: run under 'cron'. Please see the script header for instructions."
    exit 255;
}

if [ -f "${RD}/config/reactor_inet_check.cf" ]; then
    . ${RD}/config/reactor_inet_check.cf
fi

PROBE_SITES="${PROBE_SITES:-8.8.8.8 www.google.com 8.8.4.4 www.facebook.com 1.1.1.1 www.amazon.com}"
MAX_FAILS=${MAX_FAILS:-3}
PING_OPTS="${PING_OPTS:--c 3 -W 5 -q}"
SDIR="${RD}/storage"

[ -f "${SDIR}/baseurl.sh" ] && . ${SDIR}/baseurl.sh

if [ -z "${LLAT}" ]; then
    AUTH=""
else
    AUTH="Authorization: Bearer ${LLAT}"
fi

if [ -f "${SDIR}/reactor_inet_check.dat" ]; then
    . ${SDIR}/reactor_inet_check.dat
fi
NEXT=${NEXT:-1}
FAILS=${FAILS:-0}
if [ ${NEXT} -gt "`echo $PROBE_SITES | wc -w`" ]; then
    NEXT=1
fi
NS=`echo ${PROBE_SITES} | sed 's/[, ]+/ /g' | cut -d ' ' -f ${NEXT}`
NEXT=`expr ${NEXT} + 1`
if ping ${PING_OPTS} ${NS}  >/dev/null 2>&1; then
    FAILS=0
    curl -s -q -o - -H "$AUTH" "${REACTOR_BASEURL:-http://127.0.0.1:8111}/api/v1/netstatus?status=1" >/dev/null
else
    FAILS=`expr ${FAILS} + 1`
    if [ $FAILS -ge $MAX_FAILS ]; then
        curl -s -q -o - -H "$AUTH" "${REACTOR_BASEURL:-http://127.0.0.1:8111}/api/v1/netstatus?status=0" >/dev/null
    fi
fi
cat <<EOS > "${SDIR}/reactor_inet_check.dat"
# This file is managed by reactor_inet_check.sh -- DO NOT EDIT/REMOVE
# Probes: ${PROBE_SITES}
LAST=`date +%s`  # `date`
NEXT=$NEXT
FAILS=$FAILS
EOS

exit 0
