//# sourceURL=widget/clock.js
/**
 * $Id: Clock.js 300 2018-03-08 18:56:13Z patrick $
 */

import Widget from '../Widget.js';
import { strftime } from '/client/util.js';

var Clock = function( elem ) {
    Widget.call(this, elem);
    this.name = "Clock";
    this.interval = false;

    $(this.elem).addClass("widget-clock");
};

Clock.prototype = Object.create(Widget.prototype);
Clock.prototype.constructor = Clock;

Clock.prototype.start = function() {
    this.interval = setInterval( this.dispatchUpdate.bind(this), 250);
};

Clock.prototype.pre_update = function() {
    var d = new Date();
    this._ctx.time = strftime( this.getData('timeformat', this.getLayoutValue( "timeformat", "%l:%M%p" ) ), d );
    this._ctx.date = strftime( this.getData('dateformat', this.getLayoutValue( "dateformat", "%a %b %e" ) ), d);
};

Clock.prototype.stop = function() {
    if ( this.interval ) {
        clearInterval( this.interval );
    }
};

Clock.prototype.click = function() {
    import( '../SlapDash.js' ).then( function( mod ) {
        mod.default.toggleFullscreen();
        // setTimeout( 'location.reload(true)', 1000 );
    });
};

Clock.prototype.updateAnalog = function( ) {
    this.log.debug(9, "In updateAnalog()");

    const d = new Date();
    const canvas = $('canvas', this.elem).get(0);
    const ctx = canvas.getContext("2d");

    canvas.style.width = '100%';
    canvas.style.height = '100%';
    canvas.width = canvas.offsetWidth;
    canvas.height = canvas.offsetHeight;

    const cx = Math.floor(canvas.width / 2);
    const cy = Math.floor(canvas.height / 2);
    let radius = cx < cy ? cx : cy;

    ctx.translate( cx, cy );
    radius = Math.floor( radius * 0.90 );

    ctx.beginPath();
    ctx.arc(0, 0, radius, 0, 2*Math.PI);
    ctx.fillStyle = this.getData( 'facecolor', this.getLayoutValue( 'facecolor', 'white' ) );
    ctx.fill();

    const edgeWidth = this.getData( 'edgewidth', this.getLayoutValue( 'edgewidth', '0.1' ) );
    if (edgeWidth > 0) {
        const grad = ctx.createRadialGradient(0,0,radius*0.95, 0,0,radius*1.05);
        grad.addColorStop(0, '#fff');
        grad.addColorStop(0.5, '#888');
        grad.addColorStop(1, '#000');
        ctx.strokeStyle = grad;
        ctx.lineWidth = radius*edgeWidth;
        ctx.stroke();

        ctx.beginPath();
        ctx.arc(0, 0, radius*edgeWidth, 0, 2*Math.PI);
        ctx.fillStyle = '#333';
        ctx.fill();
    }

    const facefont = this.getData( 'facefont', this.getLayoutValue( 'facefont', 'Arial' ) );
    if (facefont !== "") {
        ctx.font = Math.floor(radius*0.25) + 'px "' + facefont + '"';
        ctx.textBaseline="middle";
        ctx.textAlign="center";
        ctx.fillStyle = this.getData( 'textcolor', this.getLayoutValue( 'textcolor', '#000' ) );
        for(let num= 1; num < 13; num++){
            const ang = num * Math.PI / 6;
            ctx.rotate(ang);
            ctx.translate(0, -radius*0.8);
            ctx.rotate(-ang);
            ctx.fillText(num.toString(), 0, 0);
            ctx.rotate(ang);
            ctx.translate(0, radius*0.8);
            ctx.rotate(-ang);
        }
    }

    let hour = d.getHours();
    let minute = d.getMinutes();
    let second = d.getSeconds();
    //hour
    hour=hour%12;
    hour=(hour*Math.PI/6)+(minute*Math.PI/(6*60))+(second*Math.PI/(360*60));
    ctx.strokeStyle = this.getData( 'handcolor-hours', this.getLayoutValue( 'handcolor-hours', '#000' ) );
    this.drawHand(ctx, hour, radius*0.5, radius*0.07);
    //minute
    minute=(minute*Math.PI/30)+(second*Math.PI/(30*60));
    ctx.strokeStyle = this.getData( 'handcolor-minutes', this.getLayoutValue( 'handcolor-minutes', '#000' ) );
    this.drawHand(ctx, minute, radius*0.8, radius*0.07);
    // second
    second=(second*Math.PI/30);
    let sc = this.getData( 'handcolor-seconds', this.getLayoutValue( 'handcolor-seconds', '#000' ) );
    if (sc !== "") {
        ctx.strokeStyle = sc;
        this.drawHand(ctx, second, radius*0.9, radius*0.02);
    }

    ctx.translate(-cx, -cy);
};

Clock.prototype.drawHand = function( ctx, pos, length, width ) {
    ctx.beginPath();
    ctx.lineWidth = width;
    ctx.lineCap = "round";
    ctx.moveTo(0,0);
    ctx.rotate(pos);
    ctx.lineTo(0, -length);
    ctx.stroke();
    ctx.rotate(-pos);
};

export default Clock;
