//# sourceURL=widgets/Multibutton.js
/* global SlapDash */

import Widget from '../Widget.js';
import Entity from '/client/Entity.js';

var Multibutton = function( elem ) {
    Widget.call( this, elem );
    this.name = "Multibutton";
    this.rows = this.getData( "rows", 1 );
    this.cols = this.getData( "cols", 2 );
    this.labels = this.getData( "labels", false );
    $(this.elem).addClass("widget-multibutton");

    if ( this.labels ) {
        this.labels = this.labels.split( / *, */ );
    }

    this.log.setLevel( 8 );
};

Multibutton.prototype = Object.create(Widget.prototype);
Multibutton.prototype.constructor = Multibutton;

Multibutton.prototype.layoutInit = function( layoutName, descObj ) {
    const $grp = $( 'div.buttongroup', this.elem );
    console.log("width",this.elem.innerWidth(),"height",this.elem.innerHeight());
    const bwidth = Math.floor( (this.elem.innerWidth() - 12*(this.cols-1)) / this.cols );
    const bheight = Math.floor( (this.elem.innerHeight() - 12*(this.rows-1)) / this.rows );
    $( 'button', $grp ).remove();
    const $btn = $( '<button></button>' ).css( { width: bwidth, height: bheight, "font-size": Math.floor( bheight/4 ) } );
    let ix = 0;
    for ( let row=0; row<this.rows; ++row ) {
        const $row = $( '<div></div>' ).appendTo( $grp );
        for ( let col=0; col<this.cols; ++col ) {
            const $b = $btn.clone();
            if ( this.labels && ix < this.labels.length ) {
                $b.text( this.labels[ix] );
            } else {
                $b.text( String(ix) );
            }
            $b.attr( 'id', String(self.id) + ix );
            $b.appendTo( $row );
            ix++;
        }
    }
};

Multibutton.prototype.post_update = function( event ) {
    console.log("post_update",event);
};

Multibutton.prototype.click = function( event ) {
    const $btn = $( event.target );
    if ( $btn.is( 'button' ) ) {
        let id = parseInt( $btn.attr( 'id' ).replace( self.id, "" ).replace( /^-/, "" ) );
        ++id;
        console.log(String(this),"calling action for button",id);
        let act = this.getData( "action" + id, "" );
        if ( "" !== act ) {
            /* Form is [entity-selection;]action[(param=value [,...])]    */
            let e;
            let i = act.indexOf( ';' );
            if ( i < 0 ) {
                e = this.entity;
            } else {
                let e_expr = act.substring( 0, i );
                act = act.substr( i+1 );
                console.log("expr",e_expr,"act",act);
                if ( "" === e_expr || "entity" === e_expr ) {
                    e = this.entity;
                } else {
                    e = SlapDash.findEntity( e_expr );
                }
            }
            if ( e instanceof Entity ) {
                let params = {};
                i = act.indexOf( '(' );
                if ( i > 0 ) {
                    let p = act.slice( i+1, -1 );
                    act = act.substring( 0, i );
                    let t = p.split( / *, */ );
                    t.forEach( function( tt ) {
                        var m = tt.match( /^([^=]+)=(.*)/ );
                        params[m[1]] = m[2];
                    });
                }
                this.log.warn("%1 perform %2 on %4 with %3", this, act, params, e);
                this.performOnEntity( e, act, params );
            } else {
                this.log.warn("Entity expression %1 did not resolve to an entity %2", act, e);
                console.log(e);
            }
            return false;
        } else {
            this.log.warn( "%1 no action defined for button %2", this, id);
        }
    }
    return true;
};

export default Multibutton;
