#!/bin/sh

# This is a generic wrapper script to retry a command several times
# until it succeeds or fails too much. It is meant to be used in
# "Shell Command" actions. A classic example is a program or script
# that communicates with a device but may sometimes fail; using this
# wrapper script allows the command to be retried without adding
# complexity to the reaction.

# Max number of tries.
RETRIES=3

# Delay between tries. Some systems accept decimals (try: man sleep)
DELAY=1

while [ $RETRIES -gt 0 ]; do
	$* && exit 0
	RETRIES=`expr ${RETRIES} - 1`
	sleep ${DELAY}
done

exit 1
