//# sourceURL=widgets/Thermostat.js
/**
 * $Id: Thermostat.js 297 2018-03-07 20:18:44Z patrick $
 */
/* globals define */

define( [ 'Widget' ], function( Widget ) {

    const Thermostat = function( elem ) {
        Widget.call( this, elem );
        this.name = "Thermostat";
        this.entity_id = this.getData( "thermostat", this.entity_id );

        $(this.elem).addClass("widget-Thermostat");
    };

    Thermostat.prototype = Object.create(Widget.prototype);
    Thermostat.prototype.constructor = Thermostat;

    Thermostat.prototype.update = function( /* msg, context */ ) {

        if ( this.entity ) {
            const status = this.entity.getAttribute("status", "")
            $('#temperature', this.elem).removeClass();
            if ( status === "Heating" )
                $('#temperature', this.elem).addClass('therm-heating');
            else if ( status === "Cooling" )
                $('#temperature', this.elem).addClass('therm-cooling');
            else if ( status === "FanOnly" )
                $('#temperature', this.elem).addClass('therm-fanonly');
        }

        this.bindValues( this.createContextFromEntity( this.entity ) );
    };

    Thermostat.prototype.click = function() {
        return false;
    };

    return Thermostat;

}); // define
