//# sourceURL=widgets/Scene.js
/**
 * $Id: Scene.js 304 2019-01-28 18:38:00Z patrick $
*/

// TO-DO: Support for confirmation before scene is run?

import Widget from '../Widget.js';

const Scene = function( elem ) {
    Widget.call( this, elem );
    this.name = "Scene";
    this.entity_id = this.getData( 'scene', this.entity_id );
    this.room = this.getData( 'room' );
    this.layout = this.getData( 'layout', 'default' );
    this.toggle_id = this.getData( 'toggle', false );
    this.toggle_entity = false;
    this.actionScene = false;
    $(this.elem).addClass("widget-scene");
};

Scene.prototype = Object.create(Widget.prototype);
Scene.prototype.constructor = Scene;

Scene.prototype.start = function() {
    const self = this;

    /* If we have a toggle scene, fetch its entity now. */
    if ( self.toggle_id ) {
        self.addObservedEntity( self.toggle_id, "toggle_entity" ).catch( function( e ) {
            self.log.warn("Can't observe %1: %2", self.toggle_id, e);
        });
    }
};

Scene.prototype.activate = function() {
    this.setContextEntity( this.toggle_entity );
}

Scene.prototype.deactivate = function() {
    this.setContextEntity( this.entity );
}

Scene.prototype.clickXXX = function( ) {
    /* Determine which scene we're acting on (for toggle behavior) */
    if ( !this.actionScene ) {
        this.actionScene = this.entity;
    }
    /* Have scene? Go... */
    if ( this.actionScene ) {
        $(this.elem).removeClass("active inactive").addClass("update-pending");
        this.lastActive = -1;
        this.actionScene.doAction( "runScene" );
    }
    /* If link, use it. */
    const link = this.getData("link");
    if ( link ) {
        document.location.href = link;
    }
};

export default Scene;
