# Reactor (Multi-Hub/System, aka MSR) Latest Builds

**WARNING:** This directory contains development builds that may not be fully verified/validated.

**DOCKER USERS ON ARM ARCHITECTURES**: Beginning January 15, 2026, the `aarch64` *docker* image will no longer be produced. If you are using this image, please [read this post](https://smarthome.community/topic/1725/notice-to-docker-arm-users-rpi-3-4-5-and-others) for guidance on which image to switch to.

**DOCKER USERS ON RASPBIAN BUSTER (ONLY) FOR RPi: Reactor *docker* images since 22021 require that you install an OS patch to run the Reactor image in a container.** [See the install instructions](https://reactor.toggledbits.com/docs/Installation/#new-install-docker-container) for the steps to install it.

**BARE-METAL USERS: It is recommended that you update package dependencies when installing all Reactor updates.** After unpacking the Reactor archive, remove any existing `package-lock.json` file from your Reactor install directory, and then run `npm run deps` to update package dependencies.

**ALL USERS:** A hard refresh of your browser is necessary after upgrading (always).

## 26011

**USERS OF AARCH64-tagged DOCKER IMAGES:** Per [this earlier post](https://smarthome.community/topic/1725/notice-to-docker-arm-users-rpi-3-4-5-and-others), *this build will likely be the last with the `aarch64` tag*. Please follow the post's guidance for changing to one of the newer tags appropriate for your hardware and OS (32-bit `armv7l` or 64-bit `arm64`).

* Reactions UI: Fix update of display after copy in-place.
* Don't store reaction history entries for sub-reactions
* VirtualEntityController: better consistency in time-series configuration; update documentation.
* Fix an error in date display of time range conditions within certain parameters.
* *HassController*: Bless HA to 2026.1.0

## 25238

* Rules/Date-Time: Fix a regression (in 25315) where a *Date-Time* `between` condition that crosses midnight may determine incorrect state if the Rule is reloaded (e.g. by editing it or a Reactor restart) in the period after midnight but before the end time.
* Restarts on Win32 systems can now (finally) do a gradual, organized reload or shutdown.
* *HassController*: Bless HA to 2025.11.3

## 25235

* Rules/Expressions: fix an additional evaluation case from @Crille
* UI: silence an error that could occur during restarts (the shutdown process could stimulate the *Set Rules* status widget to fire queries at the inoperative host that eventually time out).
* *HassController*: Bless HA to 2025.11.3

## 25323

* Rule-based Variables: correct an error handling dependency evaluation of subscoped variables.
* *SystemController*: prevent spurious exception that could be thrown while shutting down Reactor. It had no effect, but it's preventable and I like my logs error-free.

## 25321

* `alarm()` function: has been redefined to return a boolean; *true* will be returned when the configured interval has completed; *false* in all other cases. The function previously returned the number of milliseconds remaining in the interval (less useful).
* Fix an issue where modifying a global expression that contains an `alarm()` call may not reset the timer.
* *HassController*: Bless HA to 2025.11.2

## 25315

**NOTE FOR HOME ASSISTANT USERS:** Versions of *Home Assistant* prior to 2025.01 are no longer supported as of this build. They may continue to work, but no effort will be expended to maintain compatibility going forward.

* Rules: New *Script* condition -- write an expression (simple or complex/compound) that returns a boolean (true/false) or null, just like any other condition. The `alarm()` function works in it, too! And it holds more secrets... [see docs](https://reactor.toggledbits.com/docs/Script-Conditions/) **WARNING:** This is a "bleeding edge" new feature; it may be subject to breaking changes as it evolves into final form.
* Expressions: Add new `print()` function to assist troubleshooting of complex expressions.
* *HassController*: Support for new HA selector/data type in `input_datetime` entities and other similar.
* *HassController*: Versions of *Home Assistant* older than 2025.01 are no longer supported, as support for a number of (their) deprecated features and functions is about to end.
* *HassController*: Bless HA to 2025.11.1

## 25310

* Expressions: restore ability (lost in 25304) to define a custom function in a global variable/expression and have it be available to other expressions.
* Fix some issues with the new `alarm()` function, including syncing on long intervals (make sure they sync in local time, not UTC).
* *HassController*: Bless HA to 2025.11.0

## 25308

* Expressions: Fix an error thrown when creating a function in a global expression.
* Engine: It is now possible to create constants and functions for use in expressions system-wide that are not defined using global variables. [see docs](https://reactor.toggledbits.com/docs/Expressions-%26-Variables/#the-global-environment)
* Reactions: fix an issue causing a disabled group to execute anyway.
* UI/Rules: Rule search field on offcanvas now also searches reactions by ID (parity with behavior for rules).
* Rule/Date-Time Condition: work around an anomaly in *nodejs* v24 (and maybe other versions) that would cause a *between* condition spanning a DST change to throttle the parent rule.

## 25304

* *Rules*: **POTENTIALLY BREAKING CHANGE** the evaluation mechanism for rule-based (local) variables has been changed. Users with rules that rely on specific nuances (or bugs) in the old behavior/mechanism may find their variables and rules do not work as expected. However, most users should find that the new mechanism aligns well with their expectations. See the docs for [*Variables & Expressions - Overview*](https://reactor.toggledbits.com/docs/Expressions-%26-Variables/) for a complete description.
* The "Force re-evaluation of expressions and conditions" option available in the *Set Variable* action of Rule Reactions (SET & RESET) has been removed. When a rule-based variable is used in a trigger, and the variable's value changes, the Rule will now re-evaluate itself automatically. This is part of the above changes.
* Rule Reactions (SET & RESET) now have a "Wait for completion" option. When set, the rule will wait for its Reaction to finish before allowing itself to be re-evaluated. When not set (the default), the Rule will not wait and the Reaction runs asynchronously, and therefore a change to the rule state during the Reaction's execution could cause the Reaction to be pre-empted (stopped before completion).
* *Rules*: fix handling of some very old rule conditions where the *changes* operator was stored in an older structure (i.e. handling the legacy structure had a bug).
* A new `alarm( interval_seconds )` function has been added; it can be used in global expressions (only) to cause periodic re-evaluation of the expression. This is particularly useful for expressions that don't have dependencies on other variables or entities/objects. A running timer can be cancelled by specifying an interval of zero (0).
* Expressions: fix an error in which the `sort()` function would sort the array in place rather than returning a new, sorted array (this was in conflict with its specification and intended operation, and apparently existed for a long time).
* UI/Expressions: button coordination in expressions editing has been improved, and the highlighting of error messages has been improved.
* HTTP API: A new endpoint `/api/v1/variable/:name/update` has been added to force re-evaluation of a global variable's expression and, if changed, set its new value. [See docs](https://reactor.toggledbits.com/apidocs/#Variables/)
* *HassController* HA made a breaking change in 2025.9 (pull 150721) that wasn't declared in their general release notes, affecting the `media_player.play_media` service. This service also has a new field and selector type, and two fields previously declared have been removed.
* *HassController* now has ability to filter out entities (i.e. not import entities from HA into Reactor) based on source (integration). [see docs](https://reactor.toggledbits.com/docs/HassController/#filtering-entity-data)
* *HassController* now supports binding of events directly to Reactions. This is in addition to the existing ability to bind events to entity attributes. Previously, if the user's goal was to run a Reaction in response to an event from HA, the user would need to first bind the event to a new entity and attribute, and then create a Rule triggered by that entity/attribute to launch the Reaction. Now, the Reaction can be launched directly on receipt of the event. [See docs](https://reactor.toggledbits.com/docs/HassController/#binding-events-to-reactions).
* *DynamicGroupController*: A configured group can be disabled by adding `enabled: false` to its configuration. The boolean value *false* is the only value that will be honored to disable the group (e.g. *null* and the number 0, while [*falsy* values](https://developer.mozilla.org/en-US/docs/Glossary/Falsy), will not be honored).
* Resolve an issue where some *Controller* subclass' `system` entities could lose track of their default primary attribute when unserialized (reloaded from storage at startup).
* UI: The rule search tool on the *Rule Set* left navigation offcanvas also finds Rule IDs that match the entered text (i.e. you can search by name and ID).
* UI: Fix an error that was thrown when using search on the *Rule Sets* navigation offcanvas list and some existing Reaction had no name.
* UI/Entities: Refresh all displayed entities when a structure event is received from the API (such as when reconnecting after a restart), to ensure the data displayed is the most current.
* UI/Expressions: page will now refresh all expression values when a structure event is received (e.g. after a restart of Reactor), as the Engine start and update of global variables often occurs before clients reconnect to the service, so clients can easily miss the update events from those objects.
* UI/Client API: fix an issue where a group entity could be assigned the wrong entity class.
* UI/Rules: Fix column not wrapping on large value for Rule-based expressions (rule detail card).
* UI/Reaction Editor: the single-action try button (for *Entity Action*s) now correctly omits optional fields that contain no data, rather than sending blank data and expecting the *Controller* instance to sort it out.
* UI/Entity Picker: click handler now covers an empty area when no entity has been selected.
* UI/modal dialogs: the ESC key will now dismiss most dialogs; if the dialog is a confirmation, the dismissal is equivalent to hitting "Cancel".
* Pushover Notifier: remove extraneous debug message.
* Developers of *Controller* subclasses: the *Controller* method  `removeControllerGroup()` is now deprecated. To replace its functionality, you should now set the class static property `createControllerGroup` to `false`. [See docs](https://reactor.toggledbits.com/docs/Building-Controllers/#suppressing-the-controller-group). The old method will continue to be available until October 2026, but will generate a warning to the log, unless the class property is also set, in which case the warning is reduced to informational level (i.e. you can do both for compatibility until next year).
* Tools: added a new trivial backup script.
* Docker images: now built with *nodejs* LTS (22.20 as of this entry) on Alpine 3.21
* *HassController*: Bless Hass to 2025.10.4

## 25208

* Status page: fix an issue placing the widget adder tool.
* *HTTP Request* now offers storage of the query response in "advanced form." This is a structure (object) that includes the response body as well as the response status, messages, and response headers. The simple form (store body or *null*) is the default and all existing *HTTP Request* actions will use the simple form response unless/until modified.
* *Telegram* notifications now support photo and video messages. To send a photo or video message, select the appropriate *Message Format* and place the URL or filename in the *Message* field. *Telegram*'s limits for file type and size must be observed (refer to their documentation).
* *HassController*: Configuration for `filter_entity` now accepts regular expressions to match to entity IDs (i.e. it can now do pattern matching, not just match exact strings). Specify regular expressions in `/regexp/flags` form (e.g. /^update./i to match IDs that begin with `update.`, case insensitive; *flags* are optional, and the only flag supported right now is `i` for case-insensitive matching).
* *HassController* will requery for service data if the lookup of service data from the startup query does not have the needed info. This can occur when an integration is not fully up and running when HA restarts -- HA will only report on services for fully running integrations at the time. The requery updates the service data for integrations that start later.
* *HassController* remove old entity mapping configuration that was preventing a user-settable attribute (`dimming.step`) from being changed by the user permanently.
* Expressions: new `geodist()` extension function to compute Great Circle Distance between two points (presumably on Earth). See docs for details. Example: `kilometers = geodist( lat1, lon1, lat2, lon2 )`
* *HassController*: Bless Hass to 2025.7.3

## 25139

**BARE-METAL USERS:** You **must** execute the shell command `npm run deps` in your Reactor install directory after upgrading, to update package dependencies. **The UI may not start if you fail to do this.** This advisory does not apply to *docker* containers.

**BARE-METAL USERS:** *nodejs* version 18 is End of Life (EOL) as of April 30, 2025, and is no longer supported. For best results and longevity, upgrade to an even-numbered version of *nodejs*. The current LTS (Long Term Support) version (recommended) is 22 and will go EOL in April 2027.

**BREAKING CHANGE FOR DEVELOPERS:** If you use `Entity.registerAction()` and specify a function, the target function now takes the canonical action name as its second argument, and the action parameters will be the third argument (the target entity remains the first argument). That is, the signature of the function has changed from `targetFunc( entity, params)` to `targetFunc( entity, actionName, params)`.

* Engine: Improve the approach of *Rule State* conditions to changes in the subject rule's state that don't end up changing the top-level rule state. This should considerably reduce potential throttling that can occur when inter-related/co-dependent rules change.
* Reactor UI: On the Entities list, fixed a minor display error in the display of atttribute values when an attribute other than the entity's primary is selected.
* Reactor UI: Reworked the URL routing so that linking to tabs and objects is possible. For this build, this will be most visible in many (but not all) of the Status tab widgets. More linking will be done in future. There's a lot more to do; please don't bother reporting areas where objects are not linked at this time.
* Reactor UI: The *Rule Sets* offcanvas navigation now has a search field that allows you to search for a rule by name.
* Upgraded some packages used by Reactor to maintainer's latest versions.
* *HassController*: Bless Hass to 2025.5.2

## 25097

* Expression syntax enhancement: it is now possible to use a variable's value as a key when creating an object on the fly. For example, if the variable `cmd` contains the word "econo" (presumably derived from configuration or some other dynamic source), it is now possible to create an object `{ econo: true }` by enclosing the key source in square brackets: `obj = { [cmd]: true }`. For reference, this syntax mimicks *JavaScript*.
* Fixed a UI crash when bringing up Reactor initially after using the *About* page bypass.
* *OWMWeatherController:* implement `sys_system.restart`, which will cause all locations to be refreshed immediately.
* *OWMWeatherController:* new config option (boolean) `ignore_certs` can be set to ignore certificate errors. These seem to pop up occasionally, perhaps because of a misconfiguration in the load balancing at *OWM*.

## 25082

**NOTE:** Bare-metal users, please run `npm run deps` in your Reactor directory after updating, then restart. Generally, you should always do this after upgrading to a new build, but for this build in particular, it's necessary.

* Status Tab: fix an error that could cause lost notifications on object changes to some widgets.
* Packages: update some packages and force one dependency to eliminate a warning from *node* about a deprecated subsystem (not every package has caught up yet).
* Reactor UI: improve cleanup and memory utilization of tabs when switching between them.
* Engine: The `isRuleSet()` and `isRuleEnabled()` expression functions now trigger re-evaluation of expressions in which they appear when the subject rule changes state.
* *HassController*: Bless Hass to 2025.3.4

## 25067

* Fix a runtime error thrown when creating a *Reaction* in a *Rule Set*.
* Fix a race condition causing a runtime error in some browsers when the "Exit" button is hit on a Reaction Editor instance. The error was discovered to be more reliably reproducible when the *Reaction* being edited had a group (i.e. used an interior/child instance of a Reaction Editor).
* Fix deletion of global expression.

## 25060

* *Reactions*: Reactions can now be assigned to a *Rule Set*. This is strictly an organizational tool/capability for user convenience. For purposes of the *Engine*, *Reactions* in *Rule Sets* are still *Global Reactions*. That means, for example, that a *Rule* from one *Rule Set* can still run a *Reaction* in another *Rule Set*.
* UI: The login page background should now look better on ultra-wide or beyond XXL monitors.
* Docs: clarify formatting requirement for YAML octal values (must use 1.2 spec `0o` prefix; the old `0` prefix without `o` no longer works).
* Structure: improve startup handling of controllers and messages around controller startup and status (e.g. inability to load an implementation, etc.). These changes are cosmetic and intended to provide more helpful log messages when things don't go well.
* Fix a sync problem in the *Current Alerts* and *Controller Status* Status tab widgets across restarts of the Reactor service.
* *VeraController*: Fix an issue with `lock.set` affecting both it and `toggle.toggle` for locks.
* *HassController*: Bless Hass to 2025.2.5

## 25016

**HOME ASSISTANT NOTE:** Versions of Home Assistant earlier that 2024.1.0 are no longer supported. They may continue to work, but I won't be troubleshooting any issues that come up with them.

**NODEJS V18 EOL:** If you are using *nodejs* version 18, it will go off maintenance on April 15, 2025, and is therefore now deprecated. Please update to a more recent version. Even-numbered LTS versions are recommended. Version 20 will go EOL in April 2026, and version 22 (recommended) in 2028.

* Reaction List: Fix an error thrown when creating a new Reaction.
* Dashboard: improve display of ValueSensor class objects for capabilities temperature_sensor, humidity_sensor, battery_level, and volume.
* *HassController*: Support new vacuum `activity` attribute and values (see [HA 2025.1 release info](https://developers.home-assistant.io/blog/2024/12/08/new-vacuum-state-property/)).
* *HassController*: Support state for lawn mowers.
* *HassController*: Add `x_hass_system.reload_configuration` and `x_hass_system.restart` actions.
* *HassController*: Bless Hass to 2025.1.2

## 24366

* Fix an issue with the Entities list not filtering by group correctly.
* Fix an issue with the Entities list not presenting the "Primary Value" alternate selector when a capability filter is active.
* Fix an issue with the Global Expression editor not freeing resources when closing (since 24302).
* Dashboard: adjust the action areas of *Level* widgets for more predictable touches on small devices.
* *HassController*: Force a refresh of extended capabilities when the *Home Assistant* server version changes.
* Entities List: adjust spacing of rows for improved appearance.
* Rule Sets: Fix alignment of title for Rule Set selection panel (offcanvas).
* Rules/conditions: Fix appearance (size) of fields in *Interval* condition.
* Rules: (experimental) Show the rule state history on the detail panel (Rules tab, open rule panel).
* Status: Fix an issue where widget frames may not be correctly upgraded when upgrading Reactor to 24343 (and beyond).
* *HassController*: Bless Hass to 2024.12.5

## 24343

**NOTE:** Notable UI Change: removing widgets on the Status tab now requires you to drag the widget (by its header) to the top navigation bar and release it there. Previously, moving a widget anywhere outside the content panel would remove it, but this was troublesome for small touch displays (too easy to remove items while scrolling).

* PR 0000389: Improve mobile device compatibility. Although many aspects of the UI have been tweaked for better presentation on small displays, it will continue to be the case that editing of major system objects (Rules, Reactions, Expressions) is a high-interactivity task, and the design goals do not and will not include "mobile first" compatibility for that.
* PR 0000387: Make *VirtualEntityController* operation of `reactor_system.set_attribute` action identical to (and in fact, just an alias for) `x_virtualentity.set_attribute`. On virtual entities, all attributes are de-facto writable.
* PR 0000386: Fix an issue with *HubitatController* where it could attempt to set `NaN` on an attribute, generating a warning in the log.
* The Reaction List has been modified to show a spinner while a Reaction is running, rather than holding a green highlight.
* Fix an issue with the Reaction List not repainting correctly after editing a (global) reaction.
* Additional hard-coded colors in some CSS styles have been removed in favor of CSS variables (Bootstrap- or Reactor-defined). This should help user making custom themes.
* Improve the error message given when a script/expression attempts to set a global variable that is not writable (i.e. it's not expressionless).
* The default action handlers for increasing/decreasing values in `dimming`, `position`, and `volume` capabilities has been updated to more consistently move in increments of the related step value. For example, when the current dimming level is 0.55 (55%), the `dimming.up` action with a step of 0.1 will move to 0.6 rather than 0.65 as previously implemented. Not all devices/*Controller*s use the default action handlers for these actions &mdash; if the *Controller* implements its own semantics, this change has no effect.
* *VirtualEntityController* can now do HTTP requests in actions. This allows you to create a virtual entity that functions as an interface for a device that is HTTP-controllable without the need to write a custom *Controller* instance. See the docs for *VirtualEntityController* for updated section on actions.
* *HassController*: Bless Hass to 2024.11.3

## 24302

**UPGRADE NOTICE:** If you are upgrading to this version from earlier than 24293, please see the notes and instructions for 24293 for additional actions you need to perform during upgrade.

* You may supply a CSS (Cascading Style Sheet) containing customizations for Bootstrap 5.3 in a file called `config/customstyles.css`. This allows you to further adjust theme colors to your liking. For instructions on how to customize Bootstrap styles, refer to its [documentation](https://getbootstrap.com/docs/5.3/customize/overview/).
* PR 0000383 (and 385): The *changes* operator was not allowing "pulse" output option. It is now allowed (whether terminal values are used or not).

## 24296

**UPGRADE NOTICE:** If you are upgrading to this version from earlier than 24293, please see the notes and instructions for 24293 for additional actions you need to perform during upgrade.

* Fix a race condition when painting the *Status* tab when painting a widget that must traverse the ruleset index.
* Make sure errors thrown by widgets show in the widget container, not by popping the exception dialog.
* Fix activation of the *Expressions* tab so it paints every time (a guard for edit mode was too aggressive, because this tab is always in edit mode).
* Fix a number of reported appearance issues, and some new ones.

## 24293

**BARE-METAL USERS: UPDATE YOUR PACKAGES!** You must run `npm i --no-save --no-package-lock --omit dev` after unpacking the Reactor distribution archive. Failure to do so will result in a non-functioning UI and many other issues.

**POTENTIAL BREAKING CHANGE:** The validity of characters in entity IDs is now enforced. Previously, only a warning was written to the log if the ID contained invalid characters; now, the entity will not be allowed to exist. If you use *VirtualEntityController*, *MQTTController*, or other *Controller*s where you can configurably create entities, the IDs you establish for those entities must now contain only valid characters, which are ASCII alphanumerics, dash (`-`), underscore (`_`), and the high ASCII ranges 192-214, 216-246, and 248-255 (which covers some letters with diacritics). Other characters, including Unicode characters outside this range, are not permitted.

**POTENTIAL BREAKING CHANGE:** The alert attributes have been moved off of the *Reactor System* (`reactor_system>system`) entity on to a separate *Reactor System Alerts* (`reactor_system>alerts`) entity. If you have *Rule*s or *Reaction*s that use alert data in conditions, you will need to point them to the new entity/attributes.

**LOCALIZATION UPDATE:** There are several new strings in the reference localization template (new version 24293). See the [Github repository](https://github.com/toggledbits/msr-localization) for the current reference version and change log.

* Entity action implementations can now return values/results and store them directly to a local (Rule-based) or global variable for further processing. Note that *HassController* was previously (in build 24115) given this ability in a slightly different form, where the response was written to a single attribute from which it could be retrieved by other expressions. *HassController* will support both mechanisms for the foreseeable future, but transition to the new mechanism is recommended.
* New *Script Action* action in Reactions allows you to run an expression/script in-line in a Reaction. This is intended to simplify handing of results from *Entity Action*s that return results.
* Scripts/expressions may now make assignments to expression-less global and local (rule-based, when the script/expression is in a Rule) variables.
* Fixed a bug in the *changes* operator where, if there were terminal values (values for *changes from*, *to*, or both), the output would pulse rather than "stick." The design intent was such that it should stick, because a change with terminal values is predictably persistent (i.e. a condition that watches for an alarm panel state change from `disarmed` to `away` will go *true* and should stay *true* as long as the alarm panel remains in `away` state). When there are no terminal values, a change is still signalled with a pulse (i.e. a change from any value to any other value produces a pulse, and is then ready to signal a change to yet another value).
* Capabilities may now define *user-writable attributes*, and the user may set the value of such an attribute on an entity. The intent of this feature is to provide storage for user preference in actions (such as the amount to change the light level when performing `dimming.up`), but could have many other uses. To make an attribute user-writable, the developer must include `writable: true` in the attribute definition. Attributes derived from device data (like switch state or blind position; i.e. where a *Controller* instance controls the value) are not writable by the user and should not be made user-writable by developers. User-writable attribute values can be set using the new *Set Attribute* button in Entity list detail cards, or using the `reactor_entity.set_attribute` action.
* New `reactor_entity` capability is extended to all entities, and contains actions to rename the entity and set its writable attributes.
* Additional work to preserve the state of attributes across upgrades/changes to underlying capabilities and implementations. The new *Controller* methods `refreshCapabilites()` and `refreshCapability()` provide a mechanism for updating an *Entity*'s stored capability data without losing the values of attributes and metadata that exist in both the old and new versions of a capability.
* Logger now supports (via `logging.yaml` entry) the rotation of log files on specific intervals. The `maxage: time` configuration can be added, where `time` is an integer followed by `secs`, `mins`, `hours`, or `days`. These may be abbreviated to a single character (e.g. `1d` or `4h`). If the `time` is an integer only, the units are assumed to be `days`.
* *DynamicGroupController* now supports an expanded form of `group_actions` configuration to more narrowly specify which actions are to be made available as group actions. See the *Group Actions* section of the documentation for *DynamicGroupController*.
* UI now has a dark theme (long-awaited).
* UI (Reaction Editor) for *HTTP Request* action now shows more clearly that when storing response to a variable, it must wait for the response to complete (i.e. when you choose a target variable, it automatically checks the "Wait for" checkbox in addition to disabling it). The semantics of this have been documented since inception, but the UI now reinforces the concept in its display.
* UI (Entities List) detail cards for Entities now have a *Perform* dropdown to run actions, rather than a list of links. The selected action is performed immediately if it has no arguments; otherwise, the arguments are requested in a modal dialog as before. This should improve access to actions on entities from this area.
* New expression functions from updated `lexpjs`: `isvalue()`, `scale()`, `constrain()`. See docs for *Expressions*.
* PR 0000380: Resolve an issue with an optional argument in a HAss-specific service requiring a value in the action editor (service climate.set_temperature for example).
* A (very) simple log file viewer/fetcher is now available at `/api/v1/log`. The optional `file` query parameter can be given to select which log file (by name); by default, `reactor.log` is displayed. This endpoint is protected when access control is enabled, so if you are using access control, you may need to modify an existing ACL or create a new one to enable access to it.
* *HassController*: Bless Hass to 2024.10.3

## 24257

* System Capabilities: the new `tag` system capability has been introduced to extend data and behavior for RFID tags and similar devices.
* *HassController*: Implement `tag_scanned` event handling, which creates a new entity from the tag ID. This entity is updated whenever *Hass* reports that the tag is detected any scanning device. This automatic event handling does not preempt or prevent user-configurable event handling for different behavior, if desired.
* *HassController*: Improve the initialization of event-driven entities so they are not cleared every time Reactor is restarted (they will be cleared only if a configuration change is detected).
* *HassController*: The event processor now ensures that `time_fired` is included in the event data before handling. If not, Reactor will provide it. In addition, since *Hass* passes `time_fired` as a string, Reactor will parse the string to an Epoch time (seconds since midnight Jan 1, 1970 UTC) and provide it in `time_fired_epoch`, which can be used in user configuration for events.
* *HassController*: Allow filtering of state attributes to reduce rule re-evaluation traffic for related entities. (see docs)
* *HassController*: Bless Hass to 2024.9.1

## 24243

**POTENTIAL BREAKING CHANGE:** The conditions in a Reaction's *repeat...while* group are meant to be *Constraints*, not *Triggers* -- they are stateless, meaning that they are evaluated each time they are run, not when an underlying condition triggers them (such as a timer expiring on a *sustained for* option). This was always meant to be the case, but an error in the UI implementation permitted certain condition options applicable only to trigger conditions. This is now fixed, and any constraints containing condition options will have those options removed during later editing, and the options will not function (they haven't been working correctly anyway) until that time.

* *Shell Command* action now supports expression substitution. This makes an already dangerous (security-wise) action even moreso, so it must be enabled explicitly by setting `allow_shell_action_substitution: true` in the `engine` configuration section of `reactor.yaml`. It is **highly** recommended that *Shell Command* actions only be used on systems that have HTTPS access and *Access Control* (user authentication) enabled, to reduce the possibility that the action could be a vector for attacking the host system and your network.
* PR 0000378: *VirtualEntityController*: fix configuration collision between virtual entities affecting time-series aggregations.
* PR 0000369: Add `error` attribute for `ev_charger` system capability documentation.
* PR 0000349: Support custom sounds for Pushover notification.
* PR 0000290: Display rule ID in rule editor (convenience).
* *HassController*: Bless Hass to 2024.8.3

## 24212

* PR 0000376: Search by name is now available on the Reactions list (similar to Entities list).
* Attribute `security_mode.state` recognizes `max` value.
* Action `security_mode.set_mode` now takes `code` argument (if not given, the default code in the *Controller*'s configuration will be applied, if available).
* Dashboard: support `/dashboard/group/<group-canonical-id>` path for direct display of a group.
* PR 0000375: Fix a path where a global variable (expressionless) could have its value modified and not update variables that depend on it.
* *HassController*: Bless Hass to 2024.7.3

## 24190

**BREAKING CHANGE:** *Home Assistant* versions prior to 2023.6 are no longer supported. Going forward, you may expect *HassController* to support *Home Assistant* releases made in the last 12 months. Older releases may continue to work, but will rececive a warning at startup, and may cause errors (that I will not troubleshoot or fix/work around). Special workarounds for pecularities of releases older than 24 months will be removed from the code (meaning versions of *Home Assistant* older than that will almost certainly have issues).

* Access Control: setting the session timeout to 0 in `users.yaml` disables timed-based session expiration.
* PR 0000374: Rolling refresh appears not to work (many UI operations don't cause enough activity to stimulate the refresh).
* PR 0000371: Localization for login page submit button.
* Conditions: Ignore excess whitespace in comma-separated list of values for "in" and "not in" condition operators.
* Rule UI: Hovering over a condition's value in a rule detail card now shows info for current and previous value.
* *HassController*: Bless Hass to 2024.7.0

## 24152

**POTENTIAL BREAKING CHANGE:** The port on which Reactor provides HTTP(S) service is now determined by the `baseurl` configuration value first. If no port is given there, the *PORT* environment variable is then queried; if that's not set, the default port is used (different for HTTP and HTTPS; see below). In previous versions, the *PORT* environment variable had the highest priority, but this is no longer the case. This will likely have no effect on most users, but if you're having trouble accessing the UI after upgrade, check your `baseurl` configuration first (if you don't have one or need an example, refer to the distribution version of `reactor.yaml` in `dist-config`. For users using Reactor via HTTPS (SSL/TLS encryption), I recommend using port 8554 in `baseurl`; regular HTTP (no encryption) remains on port 8111.

* User Authentication and Access Control. See the [Access Control](https://reactor.toggledbits.com/docs/Access-Control/) documentation. This is feature request PR 0000351.
* The default port for HTTPS-enabled Reactor is now 8554 (8111+443). If your system or docker configuration set the PORT environment variable before starting Reactor, whatever port that specifies will be used as before. See the [How-To: HTTPS](https://reactor.toggledbits.com/docs/How-To-HTTPS/) section of the documentation for information about configuring Reactor for HTTPS.
* The port used for HTTP(S) service is now determined by the port specified in `baseurl` (in `config/reactor.yaml`) first; if no port is specified in `baseurl`, the PORT environment variable is used if set, and finally the Reactor default of 8111 (or 8554 if TLS is enabled).
* If HTTPS (HTTP + SSL/TLS) is enabled and its configured port is other than 8111 (the standard HTTP (non-SSL/TLS) port for Reactor), an HTTP service on port 8111 will now be created to redirect requests from HTTP to HTTPS (no unencrypted service is provided other than redirection). This feature can be disabled by configuring `redirect_http` to `false` in the `reactor` section of `config/reactor.yaml`.
* The `allow_ips` in the `reactor` section of `config/reactor.yaml` now allows CIDR address range specification (e.g. `10/8` or `192.168.0/24`) for ranges of addresses.
* Updated the documentation theme and its supporting plugins; improved the appearance of code snippets with syntax highlighting in most cases; add line highlighting in many code snippets to draw attention to certain elements or changes.
* Dashboard: added new Thermostat type (supported by Level.updown layout) for capabilities hvac_heating_unit/hvac_cooling_unit. Evolving; further improvements coming.
* *VirtualEntityController*: Support for time-series data collection and aggregation. See the [docs](https://reactor.toggledbits.com/docs/VirtualEntityController/)).
* *VirtualEntityController*: Preserve attribute values if possible across system updates that affect capability definitions or implementations.
* *DynamicGroupController*: It is now possible to set the primary attribute of a dynamic group, and determine its value dynamically. Trivial example: add the `binary_sensor.state` attribute to a group to show *true* when any light in the group is on. Refer to the docs for *DynamicGroupController*.
* The `dist-config` directory is now copied to the user data virtual path target when running in *docker* containers so that its contents are more easily accessible to *docker* users (no need to `docker exec` into the running container).
* Rules: the logging level for most rule evaluation messages has been reduced to DEBUG0 (numeric level 5); rules will now log only startup/shutdown and rule state changes at INFO level. Per-object logging configuration can be used to enable more detailed logging for a specific rule when required.
* Fixed an issue in the core related to deleting certain objects (a Global Reaction was reported, but could have been many object types).
* Fixed an issue with local service of docs that caused a cross-site scriping error on some browsers (this is the "Initializing search..." bug).
* Developer Tools: the `util` function `deepCompare()` now works with *JavaScript* `Set`, `Map`, `Buffer`, `RegExp` objects.
* Developer Tools: documented `util` function `hash()` (it's been around a while, just not documented).
* *HassController*: Bless Hass to 2024.5.5

## 24115

* Entities UI: When a capability filter is selected, the value column header displays a selector allowing the user to display a value in the column other than the primary value for the filtered entities.
* The extensions subdirectory `ext` *may* now be located under `config`, which makes its location uniform for bare-metal and *docker* users; this will **eventually** become the standard location. It is not necessary at this time to relocate your existing `ext` directory if you have one &mdash; either or both the old and new locations will work for the foreseeable future.
* Improve the coordination of the Reactions and Rules displays when open and interacting on multiple displays (e.g. when you delete a reaction on one screen, it should disappear from the other(s)).
* Fix a browser-side performance issue/delay with reconnection to a restarting Reactor service when the Status page is up and displaying the *Recently Changed Entities* widget. This also improves the memory consumption and performance of the widget generally.
* Increase tolerance for damage to most storage objects, particularly those that only maintain state that can usually be safely rebuilt on the fly. For those that cannot, like rules and expressions, isolate a faulty file and ignore the object with an alert to the user. Preserve the broken file.
* PR 0000367 Localization of the new strings in the rule state override menu and state display have been added.
* PR 0000368 Fix missing localization string for *Copy Attributes* button in Entities list entity detail card.
* Report detected time zone and offset in startup messages. Add time zone display to hover title on browser and host times in UI header.
* New `wifi_status` [system capability](https://reactor.toggledbits.com/docs/Standard-Capabilities/#wifi_status) for WiFi-connected devices that can report connection status.
* PR 0000369 Docs: Add documentation for `ev_charger` system capability.
* *HassController* now supports [responses from services](https://www.home-assistant.io/blog/2023/07/05/release-20237/#services-can-now-respond) that support them; whether required or optional, a response will be requested and stored in `x_hass.last_response` on the target Reactor entity. The data returned is not processed in any way; it is written as-received to the attribute. Tip: if possible, always make the service call from the target entity, not from the system entity.
* *HassController*: Bless Hass to 2024.4.4

## 24057

**NOTE (BARE-METAL ONLY):** If you are upgrading to this build from a build earlier than 24052, please update your package dependencies. After unpacking the Reactor archive, remove any existing `package-lock.json` file from your Reactor install directory, and then run `npm i --no-save --no-package-lock --omit dev` to update package dependencies.

* PR 0000366: Fix an injection caused by the rule state override option added in 24052, which results in constraints on rules being handled incorrectly.

## 24052

**BREAKING CHANGE:** The `valve` capability's `state` attribute value is now *boolean*, to match similar system capabilities (was previously/erroneously *string*). If you are using an entity with the `valve` capability in conditions or actions, make sure the type for the current or target state is *boolean* now.

* Update support for many packages. Please remember to do `npm i --no-save --no-package-lock` (bare-metal installs only; *docker* containers are always up-to-date).
* Add ability to override the state of a rule from the UI, for logic debugging purposes. A disabled rule will have its state forced, but will not run its reactions. An enabled rule will also have its state forced, but the corresponding rule reaction will run on the state transition. When overridden, the trigger and constraint conditions have no effect on the overall rule state, but (if rule enabled) are still evaluated and their status is still accurately displayed on the status card for the rule in the UI.
* PR 0000357: Implement `getRule()` extension function to get rule metadata; [refer to the docs](https://reactor.toggledbits.com/docs/Expressions-%26-Variables/#special-reactor-functions) for more.
* Fix an error in the handling of the entity action cache in the UI.
* Docs: improvements to description of custom event handlers for *HassController* (still a work in progress, but isn't everything?).
* Docs: add a section in *VeraController* doc for the firmware's `UnsafeLua` flag, required to be on for the `x_vera_sys.runlua` action to be available. The value is now also published as an attribute on the system entity.
* *HassController*: Implement new HA `valve` domain with our `valve` capability.
* *HassController*: Bless Hass to 2024.2.2

## 23344

* PR 0000294: *InfluxFeed* now supports exporting of global variable values to *InfluxDB*. See [docs](https://reactor.toggledbits.com/docs/InfluxDB-Plugin/).
* *VirtualEntityController*: Fix issue where a global variable dependency (value change) was detected, but the old GV value was always retrieved.
* Dashboard: Strings displayed by ValueSensor widgets are now elastic-sized to reduce overflow.
* Dashboard: Fix group spec handling so that custom top-level dashboards for a group can be created. This needs documentation.
* *HassController*: Bless Hass to 2023.12.1

## 23338

**DEPRECATION WARNING (bare-metal installs only)**: all *nodejs* versions earlier than 18 are now end-of-life; these versions will not be supported for Reactor after 1-Mar-2024. You should upgrade *nodejs* as soon as possible. The minimum supported version is now 18.18, but for longevity, upgrading to the current LTS version is recommended. Users of Reactor running in *docker* containers are not affected, as the image always embeds a supported LTS version of *nodejs* (that is, no action is required for *docker* users).

* Expressions: Update *lexpjs* to fix degenerate case of `case` with single `when` and an `else` (which is better written as an `if...then...else`, but shouldn't throw an error in any case).
* CallMeBot: the built-in CallMeBot notifier is now deprecated. There are no plans to remove it right now, but it will not receive future updates. Use *HTTP Request* actions directly in Reactions instead.
* Reduce the frequency of reminder alerts when an upgrade is available.
* *HassController*: Bless Hass to 2023.11.3

## 23302

* Expressions: functions `asin()`, `acos()`, `atan()`, and `atan2()`, and the reserved word `pi` (lowercase), are now supported (identical to their JavaScript equivalents).
* Update the documentation for migrating (importing) rules from Reactor for Vera (the Vera Reactor Plugin).
* *HassController*: All use of `x_hass.call_service` (the entity-based service call action) now uses the `target` field to specify the `entity_id`, rather than the old form which embedded the `entity_id` in the `data` field.
* *HassController*: The `x_hass_system.call_service` (system-global service call action) has been extended to allow the user to enter a `target` field for service calls that benefit from it. It should be noted, however, that the `x_hass.call_service` action on a Reactor entity (mapping a HA entity) should be used in preference to the system-global service call whenever possible, as changes in ID by HA will break the system-global call without warning (entity-based service call actions will simply use the new ID given by HA).
* PR 0000360: Fix expression meta modification example in docs.
* *HassController*: Bless Hass to 2023.10.5

## 23242

* Rules Editor: Fixed an issue where a cond option change to the duration operator with no change to duration value may not be saved.
* *HassController*: Add mapping for `proximity` domain (to `value_sensor`).
* *HassController*: Bless Hass to 2023.8.2

## 23218

* Improve the initialization of new global variables so they don't show "not yet evaluated" until a non-null value is set (*null* is a valid evaluation result and should remove the "not yet").
* Expressions: improve the display of non-printing characters in the expression editor's "current value" display (they now display as Unicode escape sequences).
* i18n: Fix init of localized weekday names when most recent Sunday occurs in prior month (caused, for example, incorrect weekday checkbox labels in *Weekday* conditions; cosmetic only, no operational effect).
* SystemController: for Reactor update, include update branch, version, and commit as attributes on system entity.
* Entities page: New *Copy Attributes* button in entity detail copies all attribute values to the clipboard.
* *HassController*: Bless Hass to 2023.8.0

## 23196

**NOTICE:** As announced in the release note for the previous build (23171), Home Assistant versions earlier than 2022.5.3 are no longer supported.

* Introduce a maximum delay in the write-back of certain storage containers (e.g. that used for expressions).
* Docs: fix an error in an example on the *How-To: Expressions with Entities* page.
* *HassController*: Bless Hass to 2023.7.2

## 23171

**DEPRECATION NOTICE:** Support for versions of Home Assistant prior to 2022.5.3 will be removed on the next build. These older versions may continue to operate successfully with *HassController* going forward, but I will not address/fix issues for them.

* *HassController*: Bless Hass to 2023.6.2

## 23139 (Silent Update)

**Note:** This is an interim release to get a couple of fixes out before I go on vacation; I haven't completely tested this version. Only upgrade to this release if you are having one of the issues (PRs) noted below and need the fix.

* PR 0000356: Fix an issue where a rule with multiple sunrise/sunset conditions using the *between* operator chooses the first condition's before/after constraints rather than its own (i.e. it was choosing the control states from the first row rather than the current row).
* SystemController: the deprecated `suninfo.sun_angle` attribute is now removed (its replacement is suninfo.elevation).
* HubitatController: Hub variables can now be set up to 1024 characters with hub firmware 2.3.5.135 and above; for earlier firmware, the limit is 255 characters. The length limit is enforced by the hub, not *HubitatController*.
* HassController: Bless Hass to 2023.5.3

## 23114

* Conditions: add `is NOT TRUE` and `is NOT FALSE` operators. The `is NOT TRUE` operator (for example) is unlike the `is FALSE` operator in that, if the tested value is `null`, the `is NOT TRUE` operator result would be *true*, while the `is FALSE` operator result would be *false*. This distinction facilitates some tests where it may be desirable to handle `null` as equivalent to either `true` or `false` without having to provide an additional, separate `is NULL` condition (and possibly an enclosing OR group).
* DynamicGroupController: document group actions; this makes it an official feature (was experimental).
* Engine/Rule: Clean up a misspelled method name.
* InfluxFeed docs: update supported and recommended versions. [[doc](https://reactor.toggledbits.com/docs/InfluxDB-Plugin/)]
* HubitatController: Tweak reconnect timing decay (allow for longer decay when hub cannot be contacted for an extended period).
* Reactions: Clarify what "Disabled" means in the constraints of a *Group* action (incl. *Repeat...While*) of a reaction. It **does not** disable the actions in the group. The disable flag applies to the constraint conditions only, having the same effect as it would on rule-based triggers and constraints (i.e. it becomes as if the constraint conditions do not exist). [[docs](https://reactor.toggledbits.com/docs/Triggers-and-Constraints/#creating-and-organizing-groups-and-conditions)] and [[docs](https://reactor.toggledbits.com/docs/Reactions/#action-groups)]
* HassController: Bless Hass to 2023.4.6

## 23078

* Fix loading of local capabilities definitions broken in a previous build.
* HassController: Bless Hass to 2023.3.5

## 23063

* Reaction Editor (UI): restore wide fields in *HTTP Request* action; injection from changes in 23049.
* Reaction Editor (UI): fix detection of substitution in some cases that would cause single-action "try" button to not be disabled when a substitution was in the action's parameters (substitution isn't performed on single-action try).
* Entities Page: Action dialog now warns that substitution isn't performed in that tool (launching an action from entity detail panel).
* HassController: support for humidifier/dehumidifier (domain/service and device class, respectively).
* VirtualEntityController: Fix an error in config check that was not allowing underscore (`_`) in entity IDs.
* VirtualEntityController: Enforce `x_virtualentity.set_attribute` parameters more aggressively (better error message when not provided).
* VirtualEntityController: Fix an error in `x_virtualentity.set_attribute` that would cause the HTTP API to not give a response when the action completed.
* I18n: Rework the loading of locale settings files, their relation to the node or browser locale, and the configurable overrides. Reactor will now use the requested locale (host config, browser config/URL, Reactor config) even if a translation file is not available for it. This places the burden on JS' native Intl, which is ample, and reduces some complexity in Reactor's model.
* HassController: Bless Hass to 2023.3.1

## 23049

* Rule and Reaction Editors: Use fixed "helper" for drag/drop to circumvent limitations in jQuery-UI causing odd restrictions and side-effects when dragging large objects (like *HTTP Request* actions). It's not as cool-looking, but function over form is required here.
* Docs: Provide installation link for community-supplied HassOS add-on; thank you to mrw298 for this.
* HubitatController: Do not automatically select the *Hub Information* device for health probes; the new *Hub Information v3* operates differently from previous versions and now is longer usable for health probes. A device will be chosen at random unless the `probe_device` config is set. [[docs](https://reactor.toggledbits.com/docs/HubitatController/#other-configuration)]
* HassController: Bless Hass to 2023.2.5

## 23028

* UI/Rules Editor: Collapsed sections now change the color of the "hidden content" badge -- red if the hidden content contains an error that needs to be corrected before save, green if it contains modified conditions or actions, and info blue (as before) if no errors and unmodified. No badge is shown if the section is empty (as before). The badge icon has been changed to a crossed eye.
* Docs: Add *Portainer* installation instructions: https://reactor.toggledbits.com/docs/Installation-docker-portainer/
* EzloController: If there are too many consecutive timeouts on requests to the hub, recycle the hub connection.
* HassController: Bless Hass to 2023.1.7

## 23010

* *Stop Reaction* action now allows you to stop the current/running reaction. This is intended to be used in constrained groups, where a match to the constraints may stop the reaction to prevent it from doing anything else.
* New `ev_charger` system capability.
* Reaction Editor: Fix incorrect storage type for boolean arguments affecting some controllers.
* HassController: Bless Hass to 2023.1.2

## 22349

**NOTE:** If you get missing entity errors from your rules when you first start this version, **don't panic**. Just wait a few seconds and then restart Reactor; it should then start clean.

**IMPORTANT:** The bare-metal distributions no longer include package dependencies pre-installed. It is therefore **critical** that you install/update dependencies *every time you upgrade* by running `npm run deps` in the Reactor install directory (for Linux users; Windows users please refer to the [installation documentation](https://reactor.toggledbits.com/docs/Installation/#upgrade-windows-10-bare-metal). This advisory does not apply to *docker*-based installs &mdash; Reactor *docker* images always include package dependencies pre-installed.

* Expressions: `isNaN()` now returns *false* when passed `null`. This is now different from JavaScript, where `parseFloat(null)/parseInt(null)` return `NaN`, but `isNaN(null)` (oddly, IMO) returns *true*.
* Fix an error in *Group* class implementation that was causing spurious errors from *DynamicGroupController* after a member entity was deleted or purged.
* VeraController: Improve detection of UV sensor child devices registered as *GenericSensor* device type and having *LightSensor1/CurrentLevel* state variable when *LightSensor1* isn't even a declared service for the type (i.e. a mess). This applies specifically to Aeotec Multi-Sensor 6 devices on 7.32beta4, but may apply to other devices/firmware.
* EzloController: Sound sensors are now handled with Reactor *value_sensor* capability.
* HassController: Bless Hass to 2022.12.6
* i18n: Improve messages for Rules/Predicates when dependent objects are missing.
* Improvements from the 22343 silent release (see below).

## 22343

This was a silent release to fix one specific issue in *EzloController*. The other items came along for the ride.

* EzloController: Guard against missing item enumerated in data for a device (data inconsistency in Ezlo API's returned device data).
* UI Entities List: UI now stores the last 10 actions and their parameters, and restores the parameters when an action is repeated.
* UI Entities List: Action parameter default values for certain types are now provided correctly (some types would come up blank even though a non-blank default was provided in the parameter definition).

## 22337

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* Rules UI: Improved detection in UI (or more correctly, notification from core to UI) of "trouble" on rules.
* HassController: reconfigure entities on HA version change; support for person, weather, number, button, sun.
* HTTPAPI: API requests are now logged by default.
* HTTPAPI: A malformed `monitored_entities` configuration will no longer prevent the `perform` API request from completing.
* HassController: Bless Hass to 2022.11.5

## 22328

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* The `baseurl` config key/value is no longer required in most cases; it is used only in exceptional circumstances. It is now commented out in default configurations (`dist-config/reactor.yaml`), and setting it is no longer required as an installation step. Users configuring their systems to use HTTPS access to the Reactor UI should, instead of using `baseurl: https://...`, set `use_tls: true` in the `reactor` section of their configuration.
* Improve messages in *Run Reaction* actions when there is an error starting the reaction.
* DynamicGroupController: make sure change in group name in configuration is always applied at startup.
* HassController: implementation for `device_tracker` service to location capability.
* HassController: since HA appears to provide conversion, enable all color modes if any is supported.
* HassController: Add support for new `xy_color` capability.
* HassController: Allow *YAML* form service data in `call_service` actions. The service data can now be formatted as *YAML* or *JSON*. The former is the default unless `{` is the first character in the field, to preserve compatibility with existing actions using JSON data.
* Add `xy_color` system capability.
* Fix a startup issue on Windows.
* PR 0000345: Fix expression doc example for `each` statement
* HassController: Bless Hass to 2022.11.4

## 22310

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* Fix missing favicon for UI

## 22308

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* PR 0000343: Fix missing fields for notification action (Pushover title reported; 22305 injection).
* PR 0000342: Documentation fix, error in example code for `if` expressions in Expressions doc.
* PR 0000341: Ease entity ID restriction (for users with international characters in entity IDs).
* PR 0000340: Localization of "upgrade available" alert message.
* PR 0000339: push()/unshift() functions not working as expected (not a lexp issue, it's a last-value storage/comparison problem when value is object type).
* PR 0000338: Version/license/meta info for extensions is now displayed on the *About* page.

## 22305

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* Engine: fix bug that could cause expressions having array or object results to not detect change reliably.
* UI/Rules/Reactions: the *changes* operator should not be available in constraints (*changes* is an event, and constraints are static, not event-driven).
* UI/Rules Editor: enforce minimum size for condition type menu (tidier layout).
* UI/Reaction Editor: improve field layout, prevent fields from pushing controls out of container, enforce minimum size for action type menu (tidier layout).

## 22302

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* UI/Status: Running Reactions widget now has "stop" button to terminate a running reaction (caveat operator).
* UI/Status: Tighten the display up a bit (remove excess whitespace).
* UI/Status: Fix alerts list that can overflow its container horizontally, causing a confusing display with multiple scoll bars.
* UI/Rule Editor: An notice/badge is now shown for collapsed sections that are not empty (i.e. when content is hidden).
* Fix condition operator "is EMPTY" (and its negated partner) on array type operand (only) was incorrectly reporting not empty in some circumstances.
* Additional UI embellishments for condition (triggers/constraints) and action (reactions) drag-drop. Still some limitations/inconsistencies/bugs in *jquery-ui* (which provides the drag/drop/sort implementation). If you can't get your object exactly where you want it, drop it close (i.e. into the group you want it in), then drag it again to its final position within the group.
* Action logging from all controllers now uses INFO level logging rather than forced logging (this is mostly a help to me because I separately log warning and higher priority in my test and home configurations so I can more clearly see errors -- it removes noise from that).
* HassController: Bless Hass to 2022.10.5

## 22293

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* PR 0000337: Condition with "sustained for" less than X seconds malfunctions (triggers immediately).
* PR 0000336: Fix group error indication not clearing when creating new group in a reaction (global or rule-based).
* Fix an error in the translation string for "sustained for" options when the "less than X seconds" form is used (was showing incorrectly in rule status view human-readable form).
* VirtualEntityController: scheduling of HTTP requests can now be done at specific times via the `at` setting for the request (an alternative to `interval`). [[docs](https://reactor.toggledbits.com/docs/VirtualEntityController/#http-request-driven-entities)]
* VirtualEntityController: the `quiet_failure` flag now accepts either a boolean value *or integer*; if boolean *true*, notifications are never sent for failed HTTP requests. If numeric, a notification is sent only after that number of requests has failed. [[docs](https://reactor.toggledbits.com/docs/VirtualEntityController/#http-request-driven-entities)]

## 22291

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* HubitatController: **Breaking change:** Devices that use HE's *PressureMeasurement* capability will now report pressure on `pressure_sensor.value` rather than the generic `value_sensor.value`. I'm not sure this is widely used if at all, so I chose to just make the breaking change rather than deprecate and hold on to the old behavior for months.
* PR 0000283: Reactions Editor: allow drag-drop between groups. This still has some minor issues, but these are due to limitations/defects in [jquery-ui](https://jqueryui.com/) (so we'll have to live with them for now).
* PR 0000334: Docs, fix an error in the example expression for metadata.
* HubitatController: Implement polling as a replacement for Hubitat's *Z-Wave Poller* app, which is widely reported to not work well (the author's own experience corroborates these reports). Polling is only needed for legacy Z-Wave devices that do not support instant status or some equivalent (hail, etc.) that Hubitat understands. [[docs](https://reactor.toggledbits.com/docs/HubitatController/#polling)]
* DynamicGroupController: the `include_entity` and `exclude_entity` selectors now can use a regular expression to match entity canonical IDs. [[docs](https://reactor.toggledbits.com/docs/DynamicGroupController/#filtering-the-dynamic-part)]
* InfluxFeed: New advanced attribute handling key `skip_null` to suppress export of *null* measurement values; [[docs](https://reactor.toggledbits.com/docs/InfluxDB-Plugin/#advanced-attribute-handling)]
* Fix a sync issue in the UI when deleting entities that previously required a hard refresh of the browser.
* UI: Fixed alignment of icons and buttons for large items in the Alerts widget (Status page).
* Documentation: Updated documentation on [building *Controller*s](https://reactor.toggledbits.com/docs/Building-Controllers/), and provided new example code (*WhiteBITController*).
* HassController: Tighten capabilities for voltage, current, energy, power, and humidity sensor types. **If you have automations using temperature or humidity sensors in Hass, please make sure your conditions use the `temperature_sensor.value` or `humidity_sensor.value` attributes, and not the generic `value_sensor.value` attribute -- this generic attribute is now deprecated and will be removed from a future release.**
* HassController: Bless Hass to 2022.10.4

## 22274

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* HubitatController: Fix too-aggressive caching of entities that makes entity names too "sticky" when device name or label is changed on hub. Note that a particularity of Hubitat, unlike most other hubs currently supported, requires a soft restart of either the controller instance (using `sys_system.restart` on the HubitatController's system entity) or a restart of Reactor to "see" the rename (Hubitat does not send an event when a device is renamed, so Reactor can't know).
* HassController: Bless Hass to 2022.9.7

## 22266

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* PR 0000333: EzloController: problem with wss (secure websocket) connection injected at 22264.

## 22264

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* VirtualEntityController: Added ability to make HTTP requests and parse results to apply to attributes (see docs).
* PR 0000332: Fix missing "minutes" label (since BS5) on *Interval* condition fields (cosmetic).
* Added new `location` capability for geographic location (attributes: latitude, longitude, elevation). This is intended as a target for eventual geolocation integrations.
* Docs: Updated for new `owntracks_in_region` template.
* Docs: Fixed an error in the example config for *VirtualEntityController*.
* HassController: Bless Hass to 2022.9.5

## 22258

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* VirtualEntityController: This new controller type lets you create virtual entities (devices) and manipulate them. [docs](https://reactor.toggledbits.com/docs/VirtualEntityController/).
* Entities list: Fix metadata pop-ups that sometimes "stick", caused by the entity updating and the popper losing its reference element in the DOM. Also make the pop-ups more dynamic by updating them when the attribute updates.
* HassController: Devices that Hass identifies in the "motion" device class will get the `motion_sensor` capability in addition to the ubiquitous `binary_sensor`, and `motion_sensor.state` will be the primary attribute.
* VeraController: Make sure all extended per-Vera-service capabilities are defined as stubs.
* HassController: Bless Hass to 2022.9.4.

## 22257

**ALL USERS -- IMPORTANT:** If you are upgrading from any version earlier than 22256, please read the advisories and prerequisites for that build, below.

* VeraController: Specific support for iBlinds2 (Window Blind Controller mfg 647 prod 3,13) to handle its 50%=fully open way of doing business (since the covering is made up of slats/louvers, the 0 and 100 positions are closed fully tilted one direction or the other, with 50% being "flat" between the two).
* VeraController: The generic `cover.set` action was missing, and native `toggled` capability support was added for window coverings (toggles between open and closed, as one might expect).
* Dashboard: The Cover widget (window covering) was not changing its icon when the covering changed state.
* HubitatController: Tighten checking and handling around oddly-named attributes. Apparently at least one Hubitat user has a device that has a HE-native attribute with a space in its name, causing an exception to attribute naming tightened in 22256. This was causing a no-start on the controller. This version maps out non-alphanumeric characters from Hubitat to underscores, and also provides additional error handling to prevent a single attribute from stopping the controller startup.

## 22256

**ALL USERS -- IMPORTANT:** As a result of entity storage changes in this build, existing entity storage (cache) is invalidated and rebuilt *when this build is first run*. That will cause all entities to be reported as newly-discovered, even though they were known before. However, this should be minimally disruptive to your logic, if at all. You may also safely ignore any warnings you see in the logs about "incompatible serialization data" on that first run; those are expected.

* PR 0000331: In the "Pulse" output condition options, the option to limit the number of pulses vanished from the editor during the upgrade to Bootstrap 5 (i.e. since 22233). It has been restored. This did not affect the operation of existing repeat count limits on conditions. If a pulsing condition was edited, that would have removed the limit, so if you use this feature, you might check those conditions that should use it. Opening the rule detail in the *Rule Sets* list of rules to see the condition descriptions is sufficient to see if it's there or not -- you don't need to go into the editor to see it. When present, the condition description will include "repeat after *x* seconds up to *y* times."
* Fix spurious data format warning for *HTTP Request* actions.
* Entities now have *metadata* (data about data) for each attribute that provides the time last modified, as well as the previous value and the effective time of the previous value. In addition, any data type and other definition information known for the attribute will also be present. The quickest way to see attribute metadata is to hover over the name of an attribute in the detail panel of an entity in the Entities list. The attribute metadata is accessible in expressions via each entity's `attribute_meta` property. The subkeys of this property are *capability names*, and within each capability are the *attribute names*, and within the attribute names are the metadata elements. For example, in the commonly used form of expression `getEntity( entity_id ).attributes.power_switch.state` we would get the *value* of the `state` attribute in the `power_switch` capability of whatever entity was matched; this tells us if the switch is on or off. To get the time that value was set, we would use `getEntity( entity_id ).attribute_meta.power_switch.state.last_modified`. Those of you trying to use the `lastupdate` property on an entity for various purposes (such as failed node detection) should particularly take note of this change and the capability it provides.
* Docs: New page [*Expressions with Entities & Attributes*](https://reactor.toggledbits.com/docs/Expressions-with-Entities-and-Attributes/) in the *How-To* section.
* (Advisory) HubitatController: Hub variables are limited to 255 characters by the hub firmware. Attempts to set a hub variable to a longer string will fail. See the [Limitations in the *HubitatController* docs](https://reactor.toggledbits.com/docs/HubitatController/#limitations) for more details.
* VeraController: The `sys_system.reload` action was incorrectly reloading the remote Vera hub; that's not really its job, but rather the job of `x_vera_sys.reload`. If you have been using `sys_system.reload` to restart Luup, please switch to `x_vera_sys.reload`. As of this build, `sys_system.reload` will cause *VeraController* to resync all devices and entities (i.e. it's a restart of *VeraController*, not your Vera).
* HassController: Bless Hass to 2022.9.2

## 22252

* PR 0000329: Rule Editor: editing sunrise/sunset condition, if only sunrise/sunset selectors are modified last, the rule does not save as configured. If other condition fields are edited after, it saves correctly.

## 22251

* PR 0000328: Rule Editor: editing condition options of parent of nested groups opens child's condition options panel (fixed).
* Entities list: fix name search parity with entity picker (ID matches)
* Change the way object arguments to actions in reactions are stored. Previously, they were stored in the reaction as native objects by converting the given string as JSON (the input was expected to be JSON) in the UI. This made expression substitution unavailable in those (object) arguments. Now, they are stored by the UI as given (i.e. a string), so substitutions are now available in those arguments. This specifically removes the limitation that `x_hass_system.call_service` could not perform substition in its `data` argument. It now works as expected. A deprecation warning has been added to the Engine to detect argument values stored as native objects in actions that will cause an alert to be displayed notifying the user that the reaction/action needs to be edited. Any trivial edit to the field, followed by a save of the reaction, will update the form of the data and eliminate future alerts.
* Dashboard: Fix stray "x" displayed on Sensor layout when source entity's units are *null*.
* HassController: Bless Hass to 2022.9.0

## 22248

* Run Reaction action: New option "wait for completion" causes the current reaction to wait for the started reaction to finish. When unchecked (default), the started reaction runs concurrently with the reaction that starts it. This (concurrent) is the behavior of all prior versions of Reactor, and since unchecked is the default, the behavior of your existing reactions does not change (unless you go in and change it). [docref](https://reactor.toggledbits.com/docs/Run-Reaction-Action/)
* Internal changes to support release of *ZWaveJSController*

## 22240

* PR 0000327: Reaction *Entity Action* layout for additional data fields is messy.
* VeraController: Ensure `x_vera_device.failed` and `.configured` are *null* if Vera fails to provide state for these values.
* EzloController: Dead-marking and automatic removal (after delay) of entities for Ezlo devices/rooms/scenes that no longer exist (functional parity with other hub Controller objects).
* HassController: Implement mappings for scenes, scripts, and automations. All of these can have their actions run via `script.run`. Automations also can be en-/disabled using the `power_switch` capability actions (and entity primary state is the automation's en-/disabled state). All appear as runnable scenes in the dashboard.
* UI: Improve highlighting of containing groups when sort/drop changes to conditions are made.
* HassController: Bless Hass to 2022.8.7

## 22233

**BARE-METAL INSTALL USERS:** When upgrading to this version, you *must* upgrade package dependencies after unpacking the archive file (delete any existing `package-lock.json` file and then run `npm install --no-save --omit dev`). The UI will not function properly if you fail to perform this upgrade.

* Upgraded the Bootstrap library to 5.2, which gave rise to a large number of required UI changes, and an opportunity for some useful cleanups. The Bootstrap Icons library was also upgraded to 1.9. All of this also means that Internet Explorer is no longer a supported browser (use its replacement, Edge).
* HassController: Bless Hass to 2022.8.6

## 22203

* Expressions: the `time()` function has been extended to allow parsing of date/time values in strings in forms beyond ISO-8601; most simple date/time forms should work, particularly those that closely adhere to your locale's default. A string that contains only a time will be converted to that moment on the current date; a string that contains only a date will yield midnight on that date. If a given string cannot be converted, an error will be thrown. Refer to [the documentation for Expressions](https://reactor.toggledbits.com/docs/Expressions-%26-Variables/#datetime-handling-functions) for more information.
* HassController: Bless Hass to 2022.7.6
* Docs: documentation for Reactions now includes additional information about rule-based reaction behaviors and action groups, and has been "modernized" to use the terminology of Multi-Hub Reactor rather than that of the Reactor for Vera plugin.

## 22179

* HassController: Fix an issue that may randomly affect/disable assignment of primary attributes (since 22118).
* Fix a problem in *after...within* (time-restricted) sequence conditions.

## 22178

* HassController: Set null state for switches and sensors when Hass reports them unavailable.
* HassController: Bless Hass to 2022.6.7.
* Docs: Improve details in Synology/Docker installation.

## 22168

**REMINDER:** As previously announced, all *docker* images are now named with the release branch and target architecture only. The `latest` branch *docker* image for all *x86_64/amd64* systems is now named `latest-amd64` (was previously `latest-generic-amd64`). The `latest` branch image for *armv7l*, which includes Raspberry Pi systems on Raspbian Buster, is now named `latest-armv7l` (was previously `latest-raspbian-armv7l`). Please adjust your upgrade procedures and, if used, *docker-compose* or *Portainer* configurations accordingly.

* *NUTController* (for Network UPS Tools) is now available as an installable [extra](https://reactor.toggledbits.com/download/extras/).
* Documentation updates to reflect updated installation archive and *docker* image names.

## 22149

* PR 0000322: EzloController: provide mapping for Xiaomi Mini Switch (a single-button remote).
* Rule: make sure clear of trouble state (on startup) is saved if necessary (so UI updates properly without need to refresh).
* VeraController: Hack for variables named `sl_`, which are the special Luup state variables that always send updates/call watches even when set to the same value they already have (all other state variables in Vera/Luup do not behave this way, they only trigger events when their values change). In particular, these `sl_` states are changed when lock codes on locks are entered, or buttons on scene controllers are pressed. For these uses, it is important that a repeated use of the same code or button signals an additional event, so Vera/Luup's uses these special `sl_` states for those. *VeraController* now inserts an extra `_updated` attribute of the same name that can be used with the *changes* operator to detect when the `sl_` states are updated. Refer to [this forum post](https://smarthome.community/post/12089) for more information.

## 22142

* PR 0000321: HTTP API `perform` action does not send response when it succeeds (clients then time out waiting for the response that never comes).
* PR 0000320: API Docs: Fix `entity` API examples.

## 22140

* Additional localization changes.
* HassController: Bless Hass to 2022.5.5

## 22136

**NEW DOCKER IMAGE:** A new docker image, or more correctly, architecture, has been added to the builds: *aarch64*. This is for 64-bit Arm (v8) systems, including the Raspberry Pi 4 on Raspbian Bullseye, and the NVIDIA Jetson Nano (2GB and 4GB versions).

* Additional localization updates.
* HassController: Bless Hass to 2022.5.4

## 22123

* Fix output not formatting correctly for certain errors in triggers and constraints.
* DynamicGroupController: Fix an exit from the update function that may not immediately release notifications on a modified group object (a fast exit when when no eligible entities match).

## 22118

**Note: this release includes changes to package dependencies. Bare-metal users please run `npm install --no-save --omit dev` to resolve.**

**IMPORTANT**: This update includes some significant enhancements for entity tracking. On your first startup after upgrading, you may get a lot of alerts about new devices being discovered (i.e. existing devices are being noted as new) as the enhanced tracking learns what is "normal" for your system. This is expected behavior for this version on its first startup. Just clear the alerts and go on about your day. After that, you should only receive notices when new devices are added to a hub, or new hubs are configured in Reactor.

* PR 0000316: *Variable Value* condition with substitution in operand may replace expression with value in saved rule.
* PR 0000315: Improve alert message when a Rule-based reaction fails.
* PR 0000314: Fix "self-subscribe" exceptions logged after creating new Rule with local expressions and a *Variable Value* condition (exceptions clear after restart of Reactor).
* PR 0000312: Expressions `getEntity()` helper not listing or updating attributes correctly (fixed).
* Raspberry Pi Install Script: Support for 64-bit installation on Raspbian Bullseye.
* UI: Faster core startup brings up the UI more quickly, and does not wait for controller startups, so a delay in a controller becoming ready (e.g. its associated hub is offline) will no longer delay the UI being available.
* UI: You can now add an SSL/TLS certificate and have the UI and API served over HTTPS (see How-To in documentation).
* New actions in `sys_system` capability to tell a *Controller* instance to purge unused entities (i.e. that no longer exist on the hub but are still present in Reactor), delete an entity (from Reactor only, not from the hub/mesh/etc.), and rename an entity (in Reactor, not at the hub/mesh/etc.).
* UI/Entity Picker: You can now move the entity picker by dragging its title bar.
* UI/Entity Picker: The name search field will now also match on entity IDs.
* UI/Reaction editor: Changing from a group or while to another reaction type while editing would leave the conditions behind (they should be removed); fixed.
* Expressions: lexpjs updated, adds `yday` (day of year), `isoweek` (ISO-8601 week number) and `dst` (boolean) to `dateparts()` function result.
* Status: Controller Status widget now sorts down/failed controllers first.
* Docs: Added How-Tos for serving media files from Reactor's built-in web server and set up HTTPS for the UI.
* HassController: Bless Hass version 2022.4.7.

## 22080

* PR 0000311: Vera Scene controller entities missing attributes in new and existing rules.
* PR 0000310: Dependent global variable may not update after editing parent.
* HubitatController: Because the HE events websocket passes all values as strings, the new fast-update process introduced in 22067 would change (for example) a previously-numeric attribute value to a string when updated by the hub. While this doesn't generally bother conditions or expressions, the type change affects *InfluxFeed* because *InfluxDB* cannot digest the type change. The data type declared by the hub during inventory is now stored and used to remap the events feed values to keep the data types consistent on the attributes. It must be noted, however, that the data types of extension attributes (`x_hubname_...`) are driven by the hub, and are therefore not guaranteed by Reactor (types are guaranteed for Reactor-defined capabilities, e.g. `dimming`, `value_sensor`, etc.). Users exporting extension attributes into *InfluxDB* are advised to always use explicit type setting for those attributes in their *InfluxFeed* configuration. This advisory has been added to the documentation for *InfluxFeed*.
* HubitatController: An inconsistency in the (HE) attribute names between their *MediaPlayer* and *MusicPlayer* capabilities with respect to transport state is now handled correctly, so that Reactor's native `av_transport.state` attribute shows a correct value regardless of which the device uses.
* SystemController: Will now issue system alerts unconditionally when disk space becomes critical (unless disk space monitoring has been disabled by user configuration), in addition to the (previously available) values and flags on the `reactor_system>system` (*Reactor System*) entity. It's also probably a good idea to add notifications (i.e. in your own rules) for such conditions raised by the system entity, if the user is not regularly looking at the Reactor UI. See the documentation for *SystemController*.
* SystemController: A `dst` (boolean) attribute has been added to the `reactor_system>sun` (*Sun Information*) entity; it will be *true* when Daylight Saving Time is in effect, *false* otherwise.
* *HassController*: Fix `cover` capability handling on non-positionable covers (e.g. garage doors).
* Dashboard: New display for cover entities.

## 22069

* HubitatController: Fix a possible loss of attribute change across restarts of the hub (that is, when a value changes during a Hubitat restart but Reactor is not restarted).

## 22067

* PR 0000309: Exception while evaluating global reaction predicate (conditional group).
* HubitatController: Attempt to eliminate additional query to fetch full device data when a device-change event is received from the hub. Please see the [documentation](https://reactor.toggledbits.com/docs/HubitatController/) for cautions.
* UI will now highlight deprecated capabilities, attributes and actions when used.
* Bless Hass to 2022.3.3

## 22053

**BREAKING CHANGE/FIX** This version contains what may be a breaking change for some users. Some actions offer lists of predefined values (e.g. `media_source.set` offers `hdmi1`, `hdmi2`, etc.). A bug in the Reaction editor was causing a numeric index value to be stored instead of the string value (i.e. it would store 0 rather than `hdmi1`). The bug is now fixed, but any action like this previously created/edited may have had an invalid value stored in the rule or reaction to which it belongs, and this cannot be reliably automatically fixed, it generally requires user review. Most likely, these actions didn't work well for you anyway, because the erroneous numeric value would likely have given invalid results/behaviors/errors when attempted, and we just haven't noticed until now (they are fairly rarely-used actions, on the whole). The specific actions affected are: `av_repeat.set_repeat`, `muting.set`, `media_source.set`, `hvac_control.set_mode`, `hvac_blower_unit.set_mode`, `hvac_blower_swing.set_mode`, `hvac_humidifier.set_moded`, `hvac_dehumidifier.set_mode`, `zwave_device.set_config`. Hopefully this list helps you narrow down what, if any, of your rules/reactions may be affected. Just take the rule/reaction into the editor, fix the new correct value and save.

* PR 0000308: Fix issue where delay action with substitition in delay may self-replace evaluated value in stored object.
* UI: Autogrow fields get more room for datalist controls.
* UI: Fix issue with some value lists incorrectly showing and storing index values rather than actual listed value; see BREAKING notice above.
* Bless Hass to 2022.2.9

## 22049

**NOTE: Bare-metal users should run `npm i --no-save --omit-dev` to update packages for this release.

* Update *lexpjs* for new `pad()` function
* PR 0000307: Nested group would repeat interior actions outside group (reaction UI)
* Update to latest minor revisions of *jquery-ui*, *bootstrap*, *popper*. This now silences the long-endured warning when doing `npm i --no-save --omit dev`

## 22044

* PR 0000306: Certain condition options not being saved for rule-based constraints.
* PR 0000305: Copying rule expression can renumber expression in source rule.
* PR 0000302: Reaction delay "from start" working same as "from this point".
* InfluxDB: Support for more extensive control of written measurements, including name and type modification; [see docs](https://reactor.toggledbits.com/docs/InfluxDB-Plugin/#advanced-attribute-handling)
* Reactions: Fix an issue where missing device in a rule reaction does not flag trouble on the rule.
* Three new capabilities: `valve`, `scene_activation` and `battery_maintenance`. These will be fully integrated with eligible Controllers and Entities in a future release.
* Reactions: An error in a special form on the *Comment* action is fixed (simple notification).
* Expressions: New expression `case` statement; [see docs](https://reactor.toggledbits.com/docs/Expressions-%26-Variables/)
* Expressions: Fix sort in `median()` function.
* Expressions: An error in the `fileRead()` function has been fixed.

## 22028

* PR 0000301: Fix excess sensitivity to apparently unrelated devices in some conditions. I'm leaving this PR open; I think I know why this happened, and for my system it's working great, but I want to make sure I've covered all the bases, and because the fix was pretty aggressive, didn't inject anything new.
* Fix exception trying to subscribe to non-*Observer* in *Variable Value* condition.
* Logger: Allow `maxsize: 0` in log stream configuration for no log rotation at all.
* Fix condition value seen on *Date/Time* conditions in rule status display (cosmetic).
* HubitatController: implement Reactor `energy_sensor` capability; replaces `x_hubitat_energymeter`, which is now deprecated.

## 22025

* VeraController: allow arrays for `filter_entity` and `accept_entity` to be consistent with other similar applications.
* Fix an issue with setting a Rule's timebase before evaluation that may affect some rule-based expressions. Likely related to PR 0000301.

## 22023

* PR 0000296: Fixed rule throttling caused by constraints subscribing for events when they should not.
* PR 0000297: Duplicate report for 0000296.
* PR 0000298: Global expressions not updating correctly, not triggering rules correctly.
* Engine: New and very experimental *Repeat While* action (a form of group), repeats as long as its conditions are met. The group must have at least one condition or it will not run at all. The repeat will stop if either (a) the conditions result in *false* or *null*, or (b) if it's in a rule-based reaction, the contra-reaction is started by a change of rule state. It is quite possible to make reaction groups that never stop, so be careful with your logic here.

## 22022

* UI: Fix "Recently Changed Entities" not updating dynamically.
* UI: Fix an error in the new widget text on the *Status* panel.
* The `node-fetch` package requirement has been updated to version 2.6.7 or higher (in the 2.x release path). This version [is patched]() against [CVE-2022-0235]() [according to the package author](). Bare-metal users will need to remove any existing `package-lock.json` file in their Reactor install directory, and then run `npm install --no-save --omit dev`. **DO NOT** run `npm audit fix` &mdash; it will break your Reactor install.
* Docs: Update package install instructions for bare-metal installs, and in the Troubleshooting section.
* Docs: Update *docker* container installation instructions for users of Raspbian Buster (only) with additional steps to install `libseccomp2` patch required to run the image.

## 22021

* UI: Make it possible to bypass the *About* page at startup.
* UI: *Status* page now has movable, resizable widgets. A couple of new widgets have been introduced as well.
* UI: Adjusted column widths on *Entities* list to show more of canonical ID, as these can get long for Ezlo and Hass users. Hovering on the canonical ID shows the entire ID (if the column still isn't wide enough and it's clipped), and clicking on the ID automatically selects all of the text, ready for copy to clipboard.
* HubitatController: Fix `volume.set` action (media players)
* Support for `usermedia` directory inside `config`; if present at startup, the built-in HTTP server will serve files from this directory (meant primarily for media/audio files, but will serve most common file types). This allows the user to serve files from the Reactor installation without the need to separately install Apache or another web server.
* HassController: Bless Hass to 2021.12.10
* Engine: predicates have been refactored to tidy up the code and remove some duplication of functionality created when reaction group contraints were introduced.
* Clean up the `reactor_inet_check.sh` script (in `tools`).
* Docker: the OS base for armv7/RPi is now *Alpine* version 3.14 (was 3.12);

## 22010

* PR 0000291: HassController: Feature request for `reload_integration` on system entity.
* HassController: Bless Hass version to 2021.12.8

## 22004

* PR 0000289: Fix detection of loops in expressions, and add more aggressive checks for some conditions previously missed; make sure self-referencing expressions are not considered loops.
* EzloController: Update connection error recovery; cloud auth and token requests are now only done when the controller specifically denies the current token, or when too many connection retries occur. Implement retry decay, to further reduce queries to Ezlo's cloud. Overall, this makes *EzloController* more resilient in the face of Internet and Ezlo cloud outages.
* Update the little-used (that may be about to change) encrypted status packager to work in *docker* containers.

## 22001

* PR 0000284: Rule Editor: Add function to clone condition or group
* PR 0000287: Date comparison error in "between" that spans year (MDHM form); resets incorrectly at 01-01T00:00 Fix end check for next edge

## 21365

* HassController: Add `fire_event` action on system device, to fire any event.
* Deprecation warning when starting on *nodejs* version < 16 (still runs, just a notice).
* HubitatController: Enforce strict ordering on initial mode and HSM queries.
* HassController: Bless Hass version to 2021.12.7
* Docs: Add startup troubleshooting page to *Troubleshooting* section.

## 21362

* HubitatController: Fix sequencing of startup to prevent (again) mode/HSM race condition.

## 21360

* PR 0000282: DynamicGroupController: fix an error that could cause preloading of entities to fail (started in 21356).
* Updated lexpjs to 21360 to correctly handle assignment to object/array members.

## 21356

* PR 0000278: Fix an untranslated string in rule reaction name generator.
* SystemController: publish alert data on entity, making it available for use in conditions.
* EzloController: Fix bug where cancelling a house mode change causes the mode name to get the ID rather than the name.
* EzloController: support for additional items (power-related and seismicity).
* EzloController: remove `power_switch` as automatic capability on dimmable lights; not all Ezlo dimmable lights publish `switch` items, so use the presence of the `switch` item on a device as the trigger to extend `power_switch`.
* EzloController: Fix an error thrown when handling certain extension items (e.g. `electric_meter_kwh`, only on some devices).
* HubitatController: Fix handling of TamperAlert capability.
* HubitatController: Add config `warn_unresponsive` (boolean) to turn off (when set *false*) warnings for quiet channel reconnects.
* HubitatController: Support for extension capabilities where an attribute like `current` is provided without a matching capability.
* VeraController: Log slow responses from hub (helps troubleshooting bottlenecks).
* Engine: Fix error in restore of running tasks across a reboot.
* PR 0000279: Fix an error that leaves *Variable Value* conditions in global reaction constraints with no variable list from which to choose (should list global variables).

## 21351

**Users are advised only to upgrade to this release if they are affected by an issue related to the changes below; specifically, if you are not a user of Hubitat and you do not use constraints in rules or reactions, there is no need to upgrade to this release.**

* HubitatController: Aggressive management of the event websocket connection, with additional diagnostic output by default.
* HubitatController: Fix error in setup of task queue (part of attempt to control pace of outgoing actions).
* Constraints: Loosen rules on condition options for constraints in rules (a stateful context), as opposed to those in global reactions (which are stateless).
* Docs: Improve description of the `time()` function so that it's clear it can convert time strings (in ISO 8601 format).

## 21349

* Make sure client API uses port for WebSocket connection, so the UI works when on a proxy or tunnel.
* Global reactions now support action groups with constraints.
* EzloController: Additional energy capabilities on certain devices/items.
* InfluxFeed: Fix an error in parsing the configuration for `select_capability` with attributes listed.
* The `suninfo` capability (used by the *Sun Information* entity `reactor_system>sun`) has been expanded to include the `elevation` and `azimuth` of the sun's current position. The `elevation` is given in degrees above the horizon. The `azimuth` is given in degrees clockwise from North (compass direction).
* The `suninfo` attribute `sun_angle` is now deprecated and will be removed from a future release. If you are using it in conditions, please switch to using `elevation`, which is a better representation of the sun's position.
* A bug in the computation of `day_length` (in hours) in the extreme latitudes (i.e. where the sun does not cross the horizon at certain times of year) is fixed. During periods during in which the sun never rises, day length will be 0; during periods in which the sun never sets, it will be 24. Similarly, `period` could give incorrect results and will now report correctly or the conditions.

## 21342

* PR 0000275: Fix sun angle not updating in `reactor_system>sun` (Sun Information) entity.
* PR 0000274: Fix missing localization of condition operand labels in rule editor.
* HassController: More tightly map reported service_data field types into Reactor types (to improve UI experience on Hass-native actions).
* Support "object" data type in action data more universally, not just in controllers that need it.

## 21338

* HubitatController: Fix handling of mode query response (injection from additional changes in 21336).

## 21337

* Document additional keys for logging in the `dist-config` template. There is also existing, but not well-organized, docs on the *Logging* page of the manual (which at the moment lives under *Troubleshooting*).
* HubitatController: ensure `x_hubitat` and `x_hubitat_extra_attribute` capabilites are declared and extended so their attributes can be assigned as primary.
* PR 0000272: Localization issue in input fields for date/time condition.
* PR 0000273: Pulse after *sustained for* delay is shortened by the delay.

## 21336

**If you have been with Reactor since before 21075 (March 15, 2021), your `logging.yaml` configuration may have a relative path in the `name` keys of the default streams (e.g. `./logs/reactor.log`). These must be changed to just a simple filename (e.g. `reactor.log`). Reactor has been warning you at startup (in the log file) about this since 21075, if it applies to you (i.e. your logging config uses a relative path), but if you haven't seen it, you may not have changed it. The time to check it/change it is now, because the next version of Reactor that is released will not allow pathnames (relative or absolute) in this key, and will not run if it finds one.**

* DynamicGroupController: map actions in known capabilities of *selected* objects, so that groups can perform actions on their members. For example, performing the `power_switch.off` action on a group will do so on all of its members that support that action.
* Logging: Fix support of log streams so that subsystems declaring their own log streams operate correctly; fix a number of long-standing annoyances in the configuration and handling (no changes to user configuration requirements except as noted above); improved "panic mode" (used when no configured stream is writable).
* Dashboard: improved layout for `string_sensor` capability objects.
* HubitatController: Bless firmware 2.3.0.113
* HubitatController: extend recent additions to capabilities (`string_sensor`) to the mode and HSM entities. Reduce reliance on the custom/hub-specific extension capability.
* HubitatController: New "type guessing", experimental, to try to reduce effort for this hub in particular in determining device types and primary attributes. This is a work in progress (but then, what isn't?).
* PR 0000271: Fix a missing localization in rule detail panel, operator in group titles (reported by @Crille).
* Improvements to `rpi-install.sh` script to handle upgrade of *systemd* script when upgrading *nodejs*.
* A number of internal fixes related to *lint*ing of the code.
* As always, a number of documentation updates.

## 21332

* DynamicGroupController: Fix missing initialization in preload for some selectors (blocking bug, no PR in Mantis).
* Documentation build fix so all documents receive correct left navigation.
* Condition operator *is [not] EMPTY* has been added to ease checking of group member arrays and other values for emptiness; see the docs *Entity Attribute* conditions for details on what "empty" means in this context.

## 21331

* DynamicGroupController: new controller to build dynamic groups. Refer to the docs for configuration information.
* Logger: new `recycle: true/false` flag, when *true*, each startup rotates the log file so the new run starts in a fresh file (makes some debugging easier); the file mode of the logs created can now be set by setting the `mode` key.
* Bump recommended *nodejs* version to 16.13.0; versions 14 and 15 will continue to be supported through March 31, 2022; *docker* containers are built with recommended versions, and require no user action, but bare-metal users should check their *node* version (`node -v`) and if necessary make a plan to upgrade before 3/31.
* Update to lexpjs 31330; adds built-in `median( array )` function; provides extended `first...in` syntax with (new) optional result expression;
* PR 0000270: [HubitatController] Apparently Hubitat needs action pacing like *VeraController* (that is, it can be overwhelmed if too many actions are sent at once). Pacing is now enabled with a default of 25ms delay between actions.
* PR 0000269: [UI] *Rename Reaction* dialog for global reactions prepopulates name from start of editor session rather than most recent name given if rename is used several times within one session.
* Bless Home Assistant to version 2021.11.5

## 21321

* HassController: Additional updates for event handling (`init` support).
* HubitatController: Map additional capabilities.
* Internal support additions for MQTTController

## 21313

* Bless Home Assistant to version 2021.11.2
* New system capability `button` to express state of a single button or contact closure.
* PR 0000268: Sun condition shows "not between" as "between" in rule detail card.
* Add `/alert/:tag` HTTP API endpoint (DELETE method); this deprecates `/alert/:tag/dismiss`.

## 21307

* PR 0000266: An issue introduced at 21306 saves certain substitutions with the wrong data type.
* HubitatController: Resolve (hopefully) a race condition at startup.

## 21306

**Note: this release includes changes to package dependencies. Bare-metal users please run `npm update --no-save` to resolve.**

* *HTTP Request* action now has explicit control over HTTP auth, with type selection (none, Basic, Digest) and credential fields (username and password).
* PR 0000265: Correct a string that is not translated in the alerts status panel.
* i18n: Found an additional string that was not localizable.
* The *HTTP Request* action will now suppress all alerts for any error it encounters, not just HTTP errors, if the "no error alerts" option is checked.
* Update *lexpjs* to get new array set functions: `arrayIntersection()`, `arrayUnion()`, `arrayDifference()`, `arrayExclusive()` and `arrayConcat()`.

## 21297

* PR 0000264: Fix an error in the rule editor on a particular value test used in several places that could cause the entered value of a condition option to not be saved (most notable on the "repeats within" field, but also found in two other locations).
* Update to *lexpjs* 21296 to get `sort()` function for arrays, and user-definable functions from expressions. Default sort in Reactor Engine for the implemention of expression `sort()` function is (host) locale-aware. Please refer to the documentation for details.

## 21294

* PR 000263: Fix spurious log messages after deleting a global expression that contained a `getEntity()`.
* Fixed a UI issue with an expression being sorted to the top of the list then ending up at the bottom.
* The expression function `strftime()` is now locale-aware.
* Docker containers are now running on node version 16.

## 21292

* PR 0000262: Fix an error in handling date/time conditions with M/D across new year boundary.
* PR 0000261: HubitatController: Resolve an order of operations issue preventing extended attributes from being assigned as primary in local config.
* PR 0000258: (i18n) Fix string reference for condition option
* HassController: treat controller reporting NOT_RUNNING as an error and disconnect/retry
* Bless Hass to 2021.10.6

## 21286

* *InfluxFeed* now supports InfluxDB version 1.8+ and 2.0. **InfluxDB versions prior to 1.8 are no longer supported.** Please [see the documentation](https://reactor.toggledbits.com/docs/InfluxDB-Plugin/) for configuration details, as the configuration requirements for 1.x and 2.0 are different. Users of *InfluxFeed* also need to `npm update --nosave` if they are bare-metal installed.
* The behavior of rules when throttled has been improved. Note, however, that any time a rule is throttled, events could be missed (e.g. if a light that is a dependency of a rule is turned on and back off quickly when throttled, the rule may not "see" the *on* event).
* Ongoing documentation updates.
* Bless Hass to 2021.10.4

## 21285 (silent release)

* First version to contain a foreign language translation, Swedish! Thank you @Crille for your work on the translation and helping me get localization working.
* Address possible evaluation loop while using SetVariable in a rule reaction on a rule variable, where the value is an expression that contains a `getEntity()` reference.
* Documentation updates
* Further i18n fixes (thank you @Crille)
* Bless Hass to 2021.10.3

## 21281

* In prior versions, a reference to a variable (rule or global) that does not exist would cause an alert and "fail soft" by returning *null*. This (old) behavior actually hides such errors and makes them more difficult to locate, and generally speaking, you shouldn't be referring to things that don't exist. The new behavior is to throw an exception during the evaluation, which will more clearly highlight the error and make it easier to find and correct. If for some reason you still need the old behavior, you can set `deprecated_undefined_global_soft_fail` to *true* in the `engine` section of `reactor.yaml`, and such errors will soft-fail as before. The old behavior is deprecated, however, and will be removed in a few months.
* PR 0000260: Fix failure of HTTP Request (really underlying variable handling) to notice change in array of objects returned by request.
* PR 0000259: Need to more clearly highlight variables with errors in the expression editor. Failing expressions now receive orange highlight bars.
* Add `typeof()` expression function.
* Additional localization changes.
* New HTTP API additions: add alert, dismiss alert
* Bless Home Assistant to 2021.10.0

## 21277

* HubitatController: Fix a problem with setting RGB color.
* Fix an issue causing "Object not found" exceptions when evaluating a `getEntity()` call in a subcontext (e.g. within an `each` loop).
* Fix a number of issues required for localization (thank you, Crille).

## 21275

**NOTICE: This revision incorporates a breaking change to the recently-introduced `matchEntities()`. See below.**

* VeraController: Devices of type `...:FloodSensor1` now use the `leak_sensor` (specific) capability; they maintain their previous use of the generic `binary_sensor` capability for backward compatiblity with existing automations.
* EzloController: Fix a stack overflow that could occur under certain boundary conditions.
* OWMController: Fix a broken context initialization for `lexpjs` causing user-configured "extra data" fields with expressions to throw a soft error and report an incorrect (*null*) value.
* Improve interaction between Engine and UI when global expressions are created: they are now given an initial evaluation and their dependency tree built at that time. Previously, a rule reference or manual UI interaction (e.g. "Try Now" button press) was required to initialize it.
* Improve interaction between Engine and UI when global variables are deleted: the deleted variable is now removed from the Engine's evaluation dependency tree to avoid spurious "Expression Not Found" exceptions in the log for the then-deleted variable. These would stop after a restart, because the dependency tree was rebuilt at that time, but it should not take a restart to fix the tree.
* Fix an error in the parameters of the `isRuleSet` and `isRuleEnabled` expression functions that would cause a constructor error when global expressions using these functions were initialized at system startup, before the Engine had loaded the rules. This error was exposed by the changes made to support global variable dependency graphs.
* When deleting system objects, wait until all notifications have been given and returned, to assure that the object being deleted is not actually deleted before the notified object has a chance to do whatever it needs to do. The former behavior had no adverse effect; this was a change to gain new behavior necessary to support the global variable dependency tree update on delete mentioned above.
* Fix a bug in the recording of the timestamp of modification of a global variable; it was using real time rather than virtual time, so when the engine was configured for "Test Time", it was recording incorrect (i.e. non-test time) values.
* The check for circular dependencies in the evaluation of global variables was relaxed to allow self-references (e.g. `series = push( series, value )`).
* BREAKING: The `matchEntities()` function now returns only a list of canonical IDs for matched entities. You will need to use the `getEntity()` function to fetch current data for the entity if you need it. This was done because the previously-returned list of entity objects could grow "stale" (the data in the objects reflects the state at the time, not ever-changing and ongoing state as attributes change). And yes, this is exactly the kind of thing I said I try to avoid, but sometimes you just don't know all the side-effects until you see the thing in the wild. Sorry, everyone.
* New expression functions: `fileExists()`, `fileRead()`, `fileWrite()`. See [the docs]().
* Incorporates a hotfix made to 21270 for the `SetVariable` action on Vera hubs.

## 21270

* Fix an issue with EzloController not processing device match expressions correctly on newer lexpjs.
* Add `matchEntities()` function (see [docs](https://reactor.toggledbits.com/docs/Expressions-%26-Variables/))
* Further localization improvements and fixes.

## 21267

* Change the evaluation algorithm for global variables to make them reactive. That is, global variables are now automatically reevaluated when dependent global variables or entities (from use `getEntity()`) change. They will also drive evaluation of rules when a rule-based expression or trigger condition references a global variable that changes.
* A new version of lexpjs supporting the above changes is being used; this version includes local scope for the interior of most statements, which may break some expressions (in particular, those that breach etiquette and create variables inside loops but access them outside).
* First version with localization capability. Users interested in localizing the user interface for their language/country can [read the how-to documentation](https://reactor.toggledbits.com/docs/Localization/#custom-language-files).

## 21258

* Warning and clear when changing operator on condition that would clear condition options.
* Fix Vera importer geotag handling.
* VeraController: add binary `x_vera_geotag.in_region` attribute.
* HassController: implement `x_hass_system.call_service` on system entities.

## 21256

* Fix issue with *HTTP Request* action post body causing exception;
* The maximum wait time for controllers to become available when Reactor starts is now configurable via the `startup_wait` key in the `engine` section of `reactor.yaml`. Users of the similarly-named `startup_delay`, which is a fixed delay, are encouraged to use `startup_wait` instead.
* The Rule detail display in the Rule Sets list was not correctly showing some non-primitive values (objects and arrays) correctly.
* HassController: Blessed Hass version 2021.9.6

## 21243

* HubitatController: Resolve exception thrown when attempting to set mode.
* HassController: Blessed Hass version 2021.8.8

## 21239

* Expression functions `strftime()` and `format()` added. See [the updated documentation](https://reactor.toggledbits.com/docs/Expressions-%26-Variables/#special-reactor-functions).
* Direct browser (via HTML attributes) to disable spellcheck on various fields where it's inappropriate (e.g. *HTTP Request* action URL, headers and data).
* Updated to latest *lexpjs*, which has itself been updated to (hopefully) support Unicode alphabetic characters in identifier names.
* Allow expressions to have Unicode characters in their names (parity with *lexpjs*).
* Additional preparation for localization in UI and engine. For example, non-US users should notice that lists sorted alphabetically now appear in a more natural order for their configured language, rather than "ASCII" (character code ordinal) sorting.

## 21237

* EzloController: Tone down the warnings about disabling ECC ciphers for Atom; that's only needed for local access.
* PR 0000245: Fixed an issue with a hang caused by the attempt to actively stop a reaction that is blocked waiting for a child reaction (reaction group) to finish.
* PR 0000252: Enable power_switch capability for siren category on eZLO hubs.

## 21236

* Prototypical support for Ezlo Atom and PlugHub in EzloController;
* Be less aggressive with module loading in app.js for more permissive first-time startup;
* Simplify reaction stop for child tasks;
* Numerous small bug fixes/gnats in UI;
* Documentation updates and corrections.

## 21228

* Home Assistant up to version 2021.8.6 supported; the [online version of the manual](https://reactor.toggledbits.com/docs/ControllerConfig/#hasscontroller) will now state the current supported versions;
* Fix an error in `OWMWeatherController` that could cause it to stop updating;
* Unify the approach to entity filtering on all hub interface classes (controllers); this works for device entities only; it may be extended to other entities later;
* Improve error detail in messages for `EzloController` during auth phase;
* Add `isRuleSet()` and `isRuleEnabled()` functions to expressions extensions;
* Implement `set` action for `lock` and `passage` capabilities (makes them more easily scriptable in some cases);
* Fix a place in the UI where 24-hour time was not being displayed.

## 21221

* PR 0000248: Date/time restore when start is Jan comes back as "(every month)".
* Feature: Trouble signal on rules (first pass).
* VeraController: set room ID as extended attribute.
* NotifyTelegram: Add plain text formatting as explicit default override.
* Documentation updates and corrections.

## 21219

* PR 0000237: Reactor for Vera Importer imports date conditions off by one month.
* PR 0000243: Rule status display not highlighting TRUE groups like R4V.
* UI: Handle booleans with datalist so substitution can be used.
* Docs: Add example for `performAction()`

## 21218

* All Controllers: Add "set" action to "power_switch" capability
* Expose additional system entity attributes for authorization state on EzloController
* Deeper sanity-checking of controller IDs in config
* Improve HTTP startup error trap (detects attempts to run multiple instances)
* Fix a bug where stopping WSAPI during a startup abort logs an exception
* Ezlo: Quiet implementation warning for x_ezlo_object attributes
* Hubitat: Handling for MediaPlayer capability; improved implementation specificity
* The use of `app.sh` for running Reactor is now deprecated; references to this script have been removed from the installation documentation.

## 21213

* PR 0000234: Feature request: add "ignore exit code" option to *Shell Command* action.
* Added `shell_command_timeout` and `shell_command_output_limit` configs for *Shell Command* action.
* Improved capture of shell exit code and diagnostic output for *Shell Command* action.
* Add script (in `tools`) to install Reactor as a Windows service (on Windows only, of course).
* Simplify prototypical *docker-compose.yaml* file.
* Additional/trivial documentation updates and corrections.
* Improved the alert text for errors in Rule-based expressions.

## 21206

* Bless/support for latest HomeAssistant 2021.7.4.

## 21203

* PR 0000233: Fix primary attribute errors on VeraController Fibaro FGRM222 and RGBController plugin.

## 21202

* Continued effort on ir_remote and rf_remote for eZLO (PR 0000231).

## 21201

* The `remote` capability is now `ir_remote`, and a new `rf_remote` capability has been added. This is a breaking change, albeit for a single user currently, so it seems like the second-best time to make such a change.
* PR 0000231: ir_remote.send_codes is sending the wrong parameter key

## 21200

* Fix `remote.send_codes` not working
* Fix banner title.
* "Manual" (docs) link now goes to online docs if local docs are not installed.
