/* Version 25308.0844 */
/** lexpjs - Copyright (C) 2018,2021,2024,2025 Patrick H. Rigney, All Rights Reserved
 *  See https://github.com/toggledbits/lexpjs
 *
 *  This Software is open source offered under the MIT LICENSE. See https://opensource.org/licenses/MIT
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 *  documentation files (the "Software"), to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and
 *  to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in all copies or substantial portions of
 *  the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 *  THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 *  TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 */
/* global parser */

const version = 25308;

const FEATURE_MONTH_BASE = 1;   /* 1 = months 1-12; set to 0 if you prefer JS semantics where 0=Jan,11=Dec */
const MAX_RANGE = 1000;         /* Maximum number of elements in a result range op result array */

const c_quot = {                /* Default quoting */
    "\"": "\\\"",
    "\\": "\\\\",
    "\t": "\\t",
    "\n": "\\n",
    "\r": "\\r",
    "\b": "\\b",
    "\f": "\\f",
    "\v": "\\v"
};

var __refs = new Set();

(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define([], factory);
    } else if (typeof module === 'object' && module.exports) {
        // Node. Does not work with strict CommonJS, but
        // only CommonJS-like environments that support module.exports,
        // like Node.
        module.exports = factory();
    } else {
        // Browser globals (root is window)
        root.lexp = factory();
    }
}(typeof self !== 'undefined' ? self : this, function () {

/* ---------------------------------- Generated grammar (DO NOT EDIT) --------------------------------- */

/* parser generated by jison 0.4.18 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
var parser = (function(){
var o=function(k,v,o,l){for(o=o||{},l=k.length;l--;o[k[l]]=v);return o},$V0=[1,29],$V1=[1,11],$V2=[1,30],$V3=[1,33],$V4=[1,31],$V5=[1,32],$V6=[1,18],$V7=[1,19],$V8=[1,20],$V9=[1,21],$Va=[1,23],$Vb=[1,24],$Vc=[1,25],$Vd=[1,26],$Ve=[1,27],$Vf=[1,28],$Vg=[1,7],$Vh=[1,8],$Vi=[1,9],$Vj=[1,10],$Vk=[1,12],$Vl=[1,13],$Vm=[1,14],$Vn=[1,15],$Vo=[1,16],$Vp=[1,17],$Vq=[1,36],$Vr=[5,6,8,11,37,81,86],$Vs=[1,43],$Vt=[1,37],$Vu=[1,38],$Vv=[1,39],$Vw=[1,40],$Vx=[1,41],$Vy=[1,42],$Vz=[1,44],$VA=[1,45],$VB=[1,46],$VC=[1,47],$VD=[1,48],$VE=[1,49],$VF=[1,50],$VG=[1,51],$VH=[1,52],$VI=[1,53],$VJ=[1,54],$VK=[1,55],$VL=[1,56],$VM=[1,57],$VN=[1,58],$VO=[1,59],$VP=[1,60],$VQ=[1,61],$VR=[1,62],$VS=[1,63],$VT=[5,6,8,10,11,18,22,26,36,37,49,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,79,81,84,86,89],$VU=[1,64],$VV=[1,65],$VW=[1,66],$VX=[1,67],$VY=[1,75],$VZ=[1,76],$V_=[5,6,8,10,11,16,17,18,19,20,22,26,33,36,37,49,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,79,81,84,86,89],$V$=[11,79],$V01=[11,18],$V11=[11,22],$V21=[5,6,8,10,11,18,22,26,36,37,49,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,79,81,84,86,89],$V31=[5,6,8,10,11,18,22,26,36,37,49,53,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,79,81,84,86,89],$V41=[5,6,8,10,11,18,22,26,36,37,53,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,79,81,84,86,89],$V51=[5,6,8,10,11,18,22,26,36,37,61,62,63,64,65,75,76,77,79,81,84,86,89],$V61=[5,6,8,10,11,18,22,26,36,37,61,62,63,64,65,66,67,68,69,70,75,76,77,79,81,84,86,89],$V71=[5,6,8,10,11,18,22,26,36,37,77,79,81,84,86,89],$V81=[5,6,8,10,11,18,22,26,36,37,79,81,84,86,89],$V91=[1,180],$Va1=[36,89],$Vb1=[5,6,8,10,11,18,22,36,37,79,81,84,86,89],$Vc1=[8,37,81];
var parser = {trace: function trace () { },
yy: {},
symbols_: {"error":2,"expressions":3,"expr_list":4,"EOF":5,"EXPRSEP":6,"elif_list":7,"ELIF":8,"e":9,"THEN":10,"COMMA":11,"identifier_list":12,"IDENTIFIER":13,"arg_list":14,"ref_expr":15,"DOT":16,"[":17,"]":18,"QDOT":19,"QBRACKET":20,"(":21,")":22,"quoted_string":23,"QSTR":24,"dict_element":25,"COLON":26,"dict_elements":27,"element_list":28,"array_elements":29,"array_list":30,"assignment":31,"GLOBAL":32,"ASSIGN":33,"LOCAL":34,"when_list":35,"WHEN":36,"ELSE":37,"constant_expr":38,"NUMBER":39,"HEXNUM":40,"OCTNUM":41,"BINNUM":42,"TRUE":43,"FALSE":44,"NULL":45,"NAN":46,"INF":47,"PI":48,"-":49,"LNOT":50,"BNOT":51,"POW":52,"RANGE":53,"*":54,"/":55,"MOD":56,"+":57,"<<":58,">>":59,">>>":60,"BAND":61,"BOR":62,"BXOR":63,"LAND":64,"LOR":65,"==":66,"!=":67,"===":68,"!==":69,"IN":70,"<":71,"<=":72,">":73,">=":74,"COALESCE":75,"COALESCENAN":76,"?":77,"LCURLY":78,"RCURLY":79,"IF":80,"ENDIF":81,"EACH":82,"FIRST":83,"WITH":84,"DO":85,"DONE":86,"DEF":87,"CASE":88,"END":89,"$accept":0,"$end":1},
terminals_: {2:"error",5:"EOF",6:"EXPRSEP",8:"ELIF",10:"THEN",11:"COMMA",13:"IDENTIFIER",16:"DOT",17:"[",18:"]",19:"QDOT",20:"QBRACKET",21:"(",22:")",24:"QSTR",26:"COLON",32:"GLOBAL",33:"ASSIGN",34:"LOCAL",36:"WHEN",37:"ELSE",39:"NUMBER",40:"HEXNUM",41:"OCTNUM",42:"BINNUM",43:"TRUE",44:"FALSE",45:"NULL",46:"NAN",47:"INF",48:"PI",49:"-",50:"LNOT",51:"BNOT",52:"POW",53:"RANGE",54:"*",55:"/",56:"MOD",57:"+",58:"<<",59:">>",60:">>>",61:"BAND",62:"BOR",63:"BXOR",64:"LAND",65:"LOR",66:"==",67:"!=",68:"===",69:"!==",70:"IN",71:"<",72:"<=",73:">",74:">=",75:"COALESCE",76:"COALESCENAN",77:"?",78:"LCURLY",79:"RCURLY",80:"IF",81:"ENDIF",82:"EACH",83:"FIRST",84:"WITH",85:"DO",86:"DONE",87:"DEF",88:"CASE",89:"END"},
productions_: [0,[3,2],[3,3],[7,5],[7,4],[4,3],[4,3],[4,1],[12,3],[12,1],[12,0],[14,3],[14,1],[14,0],[15,1],[15,3],[15,4],[15,3],[15,4],[15,4],[15,3],[23,1],[25,3],[25,5],[25,5],[25,3],[27,3],[27,1],[28,1],[28,0],[29,3],[29,1],[30,1],[30,0],[31,4],[31,4],[31,3],[35,7],[35,5],[35,6],[35,4],[38,1],[38,1],[38,1],[38,1],[38,1],[38,1],[38,1],[38,1],[38,1],[38,1],[38,1],[9,1],[9,1],[9,1],[9,2],[9,2],[9,2],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,3],[9,5],[9,3],[9,3],[9,8],[9,6],[9,7],[9,5],[9,8],[9,6],[9,10],[9,8],[9,8],[9,6],[9,3],[9,4],[9,6],[9,3]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1:
 return $$[$0-1]; 
break;
case 2:
 return $$[$0-2]; 
break;
case 3:
 $$[$0-4].push( { test: $$[$0-2], tc: $$[$0] } ); this.$ = $$[$0-4]; 
break;
case 4:
 this.$ = [ { test: $$[$0-2], tc: $$[$0] } ]; 
break;
case 5: case 6: case 11:
 $$[$0-2].expr.push( $$[$0] ); this.$ = $$[$0-2]; 
break;
case 7: case 12:
 this.$ = atom( 'list', { expr: [ $$[$0] ] } ); 
break;
case 8: case 26: case 30:
 $$[$0-2].push( $$[$0] ); this.$ = $$[$0-2]; 
break;
case 9: case 27: case 31:
 this.$ = [ $$[$0] ]; 
break;
case 10: case 29: case 33:
 this.$ = []; 
break;
case 13:
 this.$ = atom( 'list', { expr: [] } ); 
break;
case 14:
 this.$ = vref_atom_track( $$[$0] ); 
break;
case 15:
 this.$ = atom( 'deref', { context: $$[$0-2], member: $$[$0], locs: [_$[$0-2], _$[$0]] } ); 
break;
case 16:
 this.$ = atom( 'deref', { context: $$[$0-3], member: $$[$0-1], locs: [_$[$0-3], _$[$0-1]] } ); 
break;
case 17:
 this.$ = atom( 'deref', { context: $$[$0-2], member: $$[$0], locs: [_$[$0-2], _$[$0]], op: $$[$0-1] } ); 
break;
case 18:
 this.$ = atom( 'deref', { context: $$[$0-3], member: $$[$0-1], locs: [_$[$0-3], _$[$0-1]], op: $$[$0-2] } ); 
break;
case 19:
 this.$ = atom( 'fref', { name: $$[$0-3], args: ($$[$0-1]).expr, locs: [_$[$0-3]] } ); 
break;
case 20: case 86:
 this.$ = $$[$0-1]; 
break;
case 21:
 this.$ = buffer; 
break;
case 22: case 25:
 this.$ = { key: $$[$0-2], value: $$[$0] }; 
break;
case 23: case 24:
 this.$ = { key: $$[$0-3], value: $$[$0] }; 
break;
case 28: case 32: case 45: case 52: case 53: case 54:
 this.$ = $$[$0]; 
break;
case 34:
 this.$ = atom( 'binop', { 'op': $$[$0-1], v1: atom( 'vref', { name: $$[$0-2] } ), v2: $$[$0], global: true, locs: [_$[$0-2], _$[$0]] } ); 
break;
case 35:
 this.$ = atom( 'binop', { 'op': $$[$0-1], v1: atom( 'vref', { name: $$[$0-2] } ), v2: $$[$0], local: true, locs: [_$[$0-2], _$[$0]] } ); 
break;
case 36:
 this.$ = atom( 'binop', { 'op': $$[$0-1], v1: $$[$0-2], v2: $$[$0], locs: [_$[$0-2], _$[$0]] } ); 
break;
case 37:
 $$[$0-6].expr.push( atom( 'if', { test: $$[$0-4], tc: $$[$0-2], fc: $$[$0], locs: [_$[$0-4], _$[$0-2], _$[$0]] } ) ); this.$ = $$[$0-6]; 
break;
case 38:
 $$[$0-4].expr.push( atom( 'if', { test: $$[$0-2], tc: $$[$0], locs: [_$[$0-2], _$[$0]] } ) ); this.$ = $$[$0-4]; 
break;
case 39:
 this.$ = atom( 'list', { expr: [ atom( 'if', { test: $$[$0-4], tc: $$[$0-2], fc: $$[$0], locs: [_$[$0-4], _$[$0-2], _$[$0-1]] } ) ] } ); 
break;
case 40:
 this.$ = atom( 'list', { expr: [ atom( 'if', { test: $$[$0-2], tc: $$[$0], locs: [_$[$0-2], _$[$0]] } ) ] } ); 
break;
case 41:
 this.$ = Number(yytext); 
break;
case 42:
 this.$ = parseInt( yytext.substr( 2 ), 16 ); 
break;
case 43:
 this.$ = parseInt( yytext.substr( 2 ), 8 ); 
break;
case 44:
 this.$ = parseInt( yytext.substr( 2 ), 2 ); 
break;
case 46:
 this.$ = true; 
break;
case 47:
 this.$ = false; 
break;
case 48:
 this.$ = null; 
break;
case 49:
 this.$ = NaN; 
break;
case 50:
 this.$ = Infinity; 
break;
case 51:
 this.$ = Math.PI; 
break;
case 55:
 this.$ = atom( 'unop', { op: '-', val: $$[$0] } ); 
break;
case 56:
 this.$ = atom( 'unop', { op: '!', val: $$[$0] } ); 
break;
case 57:
 this.$ = atom( 'unop', { op: '~', val: $$[$0] } ); 
break;
case 58: case 59: case 60: case 61: case 62: case 63: case 64: case 65: case 66: case 67: case 68: case 69: case 70: case 73: case 74: case 75: case 76: case 77: case 78: case 79: case 80: case 81: case 82: case 83:
 this.$ = atom( 'binop', { op: $$[$0-1], v1: $$[$0-2], v2: $$[$0], locs: [_$[$0-2],_$[$0]] } ); 
break;
case 71:
 this.$ = atom( 'binop', { op: '&&', v1: $$[$0-2], v2: $$[$0], locs: [_$[$0-2],_$[$0]] } ); 
break;
case 72:
 this.$ = atom( 'binop', { op: '||', v1: $$[$0-2], v2: $$[$0], locs: [_$[$0-2],_$[$0]] } ); 
break;
case 84:
 this.$ = atom( 'if', { test: $$[$0-4], tc: $$[$0-2], fc: $$[$0], locs: [_$[$0-4], _$[$0-2], _$[$0]] } ); 
break;
case 85:
 this.$ = atom( 'dict', { elements: $$[$0-1] } ); 
break;
case 87:
 this.$ = atom( 'if', { test: $$[$0-6], tc: $$[$0-4], alts: $$[$0-3], fc: $$[$0-1], locs: [_$[$0-6], _$[$0-4], _$[$0-3], _$[$0-1]] } ); 
break;
case 88:
 this.$ = atom( 'if', { test: $$[$0-4], tc: $$[$0-2], alts: $$[$0-1], locs: [_$[$0-4], _$[$0-2], _$[$0-1]] } ); 
break;
case 89:
 this.$ = atom( 'if', { test: $$[$0-5], tc: $$[$0-3], fc: $$[$0-1], locs: [_$[$0-5], _$[$0-3], _$[$0-1]] } ); 
break;
case 90:
 this.$ = atom( 'if', { test: $$[$0-3], tc: $$[$0-1], locs: [_$[$0-3], _$[$0-1]] } ); 
break;
case 91:
 this.$ = atom( 'iter', { value: $$[$0-6], key: $$[$0-4], context: $$[$0-2], exec: $$[$0] } ); 
break;
case 92:
 this.$ = atom( 'iter', { value: $$[$0-4], context: $$[$0-2], exec: $$[$0] } ); 
break;
case 93:
 this.$ = atom( 'search', { value: $$[$0-8], key: $$[$0-6], context: $$[$0-4], exec: $$[$0-2], result: $$[$0] } ); 
break;
case 94:
 this.$ = atom( 'search', { value: $$[$0-6], context: $$[$0-4], exec: $$[$0-2], result: $$[$0] } ); 
break;
case 95:
 this.$ = atom( 'search', { value: $$[$0-6], key: $$[$0-4], context: $$[$0-2], exec: $$[$0] } ); 
break;
case 96:
 this.$ = atom( 'search', { value: $$[$0-4], context: $$[$0-2], exec: $$[$0] } ); 
break;
case 97:
 this.$ = atom( 'block', { block: $$[$0-1] } ); 
break;
case 98:
 this.$ = atom( 'block', { block: $$[$0-2] } ); 
break;
case 99:
 this.$ = atom( 'fdef', { name: $$[$0-4], args: $$[$0-2], impl: $$[$0] } ); 
break;
case 100:
 this.$ = atom( 'case', { when_list: $$[$0-1] } ); 
break;
}
},
table: [{3:1,4:2,9:3,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{1:[3]},{5:[1,34],6:[1,35],11:$Vq},o($Vr,[2,7],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($VT,[2,52]),o($VT,[2,53],{16:$VU,17:$VV,19:$VW,20:$VX,33:[1,68]}),o($VT,[2,54]),{9:69,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:70,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:71,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:$VY,17:$VZ,23:77,24:$V3,25:74,27:73,28:72,79:[2,29]},{9:80,13:$V0,15:5,17:$V1,18:[2,33],21:$V2,23:22,24:$V3,29:79,30:78,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:81,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:[1,82]},{13:[1,83]},{4:84,9:3,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:[1,85]},{35:86,36:[1,87]},o($VT,[2,41]),o($VT,[2,42]),o($VT,[2,43]),o($VT,[2,44]),o($VT,[2,45]),o($VT,[2,46]),o($VT,[2,47]),o($VT,[2,48]),o($VT,[2,49]),o($VT,[2,50]),o($VT,[2,51]),o($V_,[2,14],{21:[1,88]}),{9:89,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:[1,90]},{13:[1,91]},o($VT,[2,21]),{1:[2,1]},{5:[1,92],9:93,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:94,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:95,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:96,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:97,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:98,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:99,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:100,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:101,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:102,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:103,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:104,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:105,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:106,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:107,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:108,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:109,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:110,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:111,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:112,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:113,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:114,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:115,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:116,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:117,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:118,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:119,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:120,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:121,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:[1,122]},{9:123,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:[1,124]},{9:125,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:126,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($VT,[2,55]),o($VT,[2,56]),o($VT,[2,57]),{79:[1,127]},{11:[1,128],79:[2,28]},o($V$,[2,27]),{26:[1,129]},{13:$V0,15:131,21:$V2,23:130,24:$V3},{26:[1,132]},{18:[1,133]},{11:[1,134],18:[2,32]},o($V01,[2,31],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),{10:[1,135],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},{11:[1,136],70:[1,137]},{11:[1,138],70:[1,139]},{6:[1,141],11:$Vq,86:[1,140]},{21:[1,142]},{36:[1,144],89:[1,143]},{9:145,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($V11,[2,13],{38:4,15:5,31:6,23:22,14:146,9:147,13:$V0,17:$V1,21:$V2,24:$V3,32:$V4,34:$V5,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp}),{22:[1,148],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},{33:[1,149]},{33:[1,150]},{1:[2,2]},o($Vr,[2,6],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($Vr,[2,5],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V21,[2,58],{52:$Vt}),o([5,6,8,10,11,18,22,26,36,37,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,79,81,84,86,89],[2,59],{49:$Vs,52:$Vt,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB}),o($V21,[2,60],{52:$Vt}),o($V21,[2,61],{52:$Vt}),o($V21,[2,62],{52:$Vt}),o($V31,[2,63],{52:$Vt,54:$Vv,55:$Vw,56:$Vx}),o($V31,[2,64],{52:$Vt,54:$Vv,55:$Vw,56:$Vx}),o($V41,[2,65],{49:$Vs,52:$Vt,54:$Vv,55:$Vw,56:$Vx,57:$Vy}),o($V41,[2,66],{49:$Vs,52:$Vt,54:$Vv,55:$Vw,56:$Vx,57:$Vy}),o($V41,[2,67],{49:$Vs,52:$Vt,54:$Vv,55:$Vw,56:$Vx,57:$Vy}),o($V51,[2,68],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o([5,6,8,10,11,18,22,26,36,37,62,64,65,75,76,77,79,81,84,86,89],[2,69],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,63:$VE,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o([5,6,8,10,11,18,22,26,36,37,62,63,64,65,75,76,77,79,81,84,86,89],[2,70],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o([5,6,8,10,11,18,22,26,36,37,64,65,75,76,77,79,81,84,86,89],[2,71],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o([5,6,8,10,11,18,22,26,36,37,65,75,76,77,79,81,84,86,89],[2,72],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o($V51,[2,73],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o($V51,[2,74],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o($V51,[2,75],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o($V51,[2,76],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP}),o([5,6,8,10,11,18,22,26,36,37,61,62,63,64,65,66,67,68,69,75,76,77,79,81,84,86,89],[2,77],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,71:$VM,72:$VN,73:$VO,74:$VP}),o($V61,[2,78],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB}),o($V61,[2,79],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB}),o($V61,[2,80],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB}),o($V61,[2,81],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB}),o($V71,[2,82],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR}),o($V71,[2,83],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR}),{26:[1,151],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},o($V_,[2,15]),{18:[1,152],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},o($V_,[2,17]),{18:[1,153],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},o($V81,[2,36],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($VT,[2,85]),{13:$VY,17:$VZ,23:77,24:$V3,25:154},{9:155,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{18:[1,156]},{16:$VU,17:$VV,18:[1,157],19:$VW,20:$VX},{9:158,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($VT,[2,86]),{9:159,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{4:160,9:3,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:[1,161]},{9:162,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:[1,163]},{9:164,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($VT,[2,97]),{9:93,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,86:[1,165],87:$Vo,88:$Vp},o($V11,[2,10],{12:166,13:[1,167]}),o($VT,[2,100]),{9:168,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{26:[1,169],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},{11:[1,171],22:[1,170]},o($V11,[2,12],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V_,[2,20]),{9:172,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:173,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:174,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($V_,[2,16]),o($V_,[2,18]),o($V$,[2,26]),o($V$,[2,22],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),{26:[1,175]},{26:[1,176]},o($V$,[2,25],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V01,[2,30],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),{6:$V91,7:177,8:[1,181],11:$Vq,37:[1,178],81:[1,179]},{70:[1,182]},{26:[1,183],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},{70:[1,184]},{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS,84:[1,185]},o($VT,[2,98]),{11:[1,187],22:[1,186]},o($V11,[2,9]),{26:[1,188],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},{9:189,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($V_,[2,19]),{9:190,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($V81,[2,34],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V81,[2,35],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V81,[2,84],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),{9:191,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:192,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{8:[1,195],37:[1,193],81:[1,194]},{4:196,9:3,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($VT,[2,90]),{9:93,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:197,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:198,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:199,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:200,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:201,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:202,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{13:[1,203]},{9:204,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($Va1,[2,40],{37:[1,205],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V11,[2,11],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V$,[2,23],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V$,[2,24],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),{4:206,9:3,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($VT,[2,88]),{9:207,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{6:$V91,11:$Vq,81:[1,208]},{10:[1,209],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},{26:[1,210],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},o($V81,[2,92],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS,84:[1,211]},o($Vb1,[2,96],{26:[1,212],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V81,[2,99],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V11,[2,8]),o($Va1,[2,38],{37:[1,213],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),{9:214,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{6:$V91,11:$Vq,81:[1,215]},{10:[1,216],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS},o($VT,[2,89]),{4:217,9:3,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:218,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:219,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:220,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},{9:221,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($Va1,[2,39],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($VT,[2,87]),{4:222,9:3,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($Vc1,[2,4],{6:$V91,11:$Vq}),o($V81,[2,91],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($Vb1,[2,95],{26:[1,223],49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($V81,[2,94],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($Va1,[2,37],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS}),o($Vc1,[2,3],{6:$V91,11:$Vq}),{9:224,13:$V0,15:5,17:$V1,21:$V2,23:22,24:$V3,31:6,32:$V4,34:$V5,38:4,39:$V6,40:$V7,41:$V8,42:$V9,43:$Va,44:$Vb,45:$Vc,46:$Vd,47:$Ve,48:$Vf,49:$Vg,50:$Vh,51:$Vi,78:$Vj,80:$Vk,82:$Vl,83:$Vm,85:$Vn,87:$Vo,88:$Vp},o($V81,[2,93],{49:$Vs,52:$Vt,53:$Vu,54:$Vv,55:$Vw,56:$Vx,57:$Vy,58:$Vz,59:$VA,60:$VB,61:$VC,62:$VD,63:$VE,64:$VF,65:$VG,66:$VH,67:$VI,68:$VJ,69:$VK,70:$VL,71:$VM,72:$VN,73:$VO,74:$VP,75:$VQ,76:$VR,77:$VS})],
defaultActions: {34:[2,1],92:[2,2]},
parseError: function parseError (str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        var error = new Error(str);
        error.hash = hash;
        throw error;
    }
},
parse: function parse(input) {
    var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = '', yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
    var args = lstack.slice.call(arguments, 1);
    var lexer = Object.create(this.lexer);
    var sharedState = { yy: {} };
    for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
        }
    }
    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == 'undefined') {
        lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);
    var ranges = lexer.options && lexer.options.ranges;
    if (typeof sharedState.yy.parseError === 'function') {
        this.parseError = sharedState.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
    }
    function popStack(n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }
    _token_stack:
        var lex = function () {
            var token;
            token = lexer.lex() || EOF;
            if (typeof token !== 'number') {
                token = self.symbols_[token] || token;
            }
            return token;
        };
    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            action = table[state] && table[state][symbol];
        }
                    if (typeof action === 'undefined' || !action.length || !action[0]) {
                var errStr = '';
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push('\'' + this.terminals_[p] + '\'');
                    }
                }
                if (lexer.showPosition) {
                    errStr = 'Parse error on line ' + (yylineno + 1) + ':\n' + lexer.showPosition() + '\nExpecting ' + expected.join(', ') + ', got \'' + (this.terminals_[symbol] || symbol) + '\'';
                } else {
                    errStr = 'Parse error on line ' + (yylineno + 1) + ': Unexpected ' + (symbol == EOF ? 'end of input' : '\'' + (this.terminals_[symbol] || symbol) + '\'');
                }
                this.parseError(errStr, {
                    text: lexer.match,
                    token: this.terminals_[symbol] || symbol,
                    line: lexer.yylineno,
                    loc: yyloc,
                    expected: expected
                });
            }
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: ' + state + ', token: ' + symbol);
        }
        switch (action[0]) {
        case 1:
            stack.push(symbol);
            vstack.push(lexer.yytext);
            lstack.push(lexer.yylloc);
            stack.push(action[1]);
            symbol = null;
            if (!preErrorSymbol) {
                yyleng = lexer.yyleng;
                yytext = lexer.yytext;
                yylineno = lexer.yylineno;
                yyloc = lexer.yylloc;
                if (recovering > 0) {
                    recovering--;
                }
            } else {
                symbol = preErrorSymbol;
                preErrorSymbol = null;
            }
            break;
        case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
                yyval._$.range = [
                    lstack[lstack.length - (len || 1)].range[0],
                    lstack[lstack.length - 1].range[1]
                ];
            }
            r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
            ].concat(args));
            if (typeof r !== 'undefined') {
                return r;
            }
            if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
        case 3:
            return true;
        }
    }
    return true;
}};

    /* Grammar 25258.02 */

    var buffer = "", qsep = "";

    function atom( t, vs ) {
        return { __atom: t, ...(vs || {}) };
    }

    function vref_atom_track( identifier ) {
        __refs.add( identifier );
        return atom( 'vref', { name: identifier } );
    }

    function D( ...args ) {
        // console.log( ...args );
    }
/* generated by jison-lex 0.3.4 */
var lexer = (function(){
var lexer = ({

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function(match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex () {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin (condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState () {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules () {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState (n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState (condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {
var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0: this.begin("STRD"); buffer = ""; 
break;
case 1: this.begin("STRS"); buffer = ""; 
break;
case 2: this.begin("STRB"); buffer = ""; 
break;
case 3: buffer += String.fromCharCode( parseInt( yy_.yytext.substring( 2 ), 16 ) ); 
break;
case 4: buffer += String.fromCodePoint( parseInt( yy_.yytext.substring( 2 ), 16 ) ); 
break;
case 5: buffer += String.fromCodePoint( parseInt( yy_.yytext.slice( 3, -1 ), 16 ) ); 
break;
case 6: buffer += "\0"; 
break;
case 7: buffer += "'"; 
break;
case 8: buffer += '"'; 
break;
case 9: buffer += '`'; 
break;
case 10: buffer += "\\"; 
break;
case 11: buffer += "\n"; 
break;
case 12: buffer += "\r"; 
break;
case 13: buffer += "\v"; 
break;
case 14: buffer += "\t"; 
break;
case 15: buffer += "\b"; 
break;
case 16: buffer += "\f"; 
break;
case 17: /* escape EOL: discard */ 
break;
case 18: buffer += yy_.yytext.charAt( 1 ); /* bogus escape => literal char */ 
break;
case 19: buffer += yy_.yytext; 
break;
case 20: return 'EOF_IN_STRING'; 
break;
case 21: this.popState(); return 24; 
break;
case 22: this.popState(); return 24; 
break;
case 23: this.popState(); return 24; 
break;
case 24: buffer += yy_.yytext; 
break;
case 25: this.begin("CMNT"); 
break;
case 26: /* discard */ 
break;
case 27: return 'EOF_IN_COMMENT'; 
break;
case 28: this.popState(); /* discard */ 
break;
case 29: /* discard */ 
break;
case 30: /* skip whitespace */ 
break;
case 31: /* skip */ 
break;
case 32: /* skip */ 
break;
case 33: return 11; 
break;
case 34: return 6; 
break;
case 35: return 34; 
break;
case 36: return 32; 
break;
case 37: return 87; 
break;
case 38: return 43; 
break;
case 39: return 44; 
break;
case 40: return 45; 
break;
case 41: return 83; 
break;
case 42: return 84; 
break;
case 43: return 82; 
break;
case 44: return 46; 
break;
case 45: return 47; 
break;
case 46: return 48; 
break;
case 47: return 80; 
break;
case 48: return 10; 
break;
case 49: return 8; 
break;
case 50: return 8; 
break;
case 51: return 8; 
break;
case 52: return 37; 
break;
case 53: return 81; 
break;
case 54: return 88; 
break;
case 55: return 36; 
break;
case 56: return 89; 
break;
case 57: return 70; 
break;
case 58: return 86; 
break;
case 59: return 85; 
break;
case 60: return 64; 
break;
case 61: return 65; 
break;
case 62: return 50; 
break;
case 63: return 13; 
break;
case 64: return 39; 
break;
case 65: return 40; 
break;
case 66: return 41; 
break;
case 67: return 42; 
break;
case 68: return 53; 
break;
case 69: return 26; 
break;
case 70: return 52; 
break;
case 71: return 54; 
break;
case 72: return 55; 
break;
case 73: return 56; 
break;
case 74: return 49; 
break;
case 75: return 57; 
break;
case 76: return 60; 
break;
case 77: return 58; 
break;
case 78: return 59; 
break;
case 79: return 72; 
break;
case 80: return 74; 
break;
case 81: return 71; 
break;
case 82: return 73; 
break;
case 83: return 68; 
break;
case 84: return 66; 
break;
case 85: return 69; 
break;
case 86: return 67; 
break;
case 87: return 67; 
break;
case 88: return 63; 
break;
case 89: return 64; 
break;
case 90: return 65; 
break;
case 91: return 50; 
break;
case 92: return 61; 
break;
case 93: return 62; 
break;
case 94: return 51; 
break;
case 95: return 75; 
break;
case 96: return 76 
break;
case 97: return 19; 
break;
case 98: return 20; 
break;
case 99: return 77; 
break;
case 100: return 33; 
break;
case 101: return 16; 
break;
case 102: return 17; 
break;
case 103: return 18; 
break;
case 104: return 21; 
break;
case 105: return 22; 
break;
case 106: return 78; 
break;
case 107: return 79; 
break;
case 108: /* skip comment */ 
break;
case 109: return 5; 
break;
}
},
rules: [/^(?:["])/,/^(?:['])/,/^(?:[`])/,/^(?:\\x[0-9a-fA-F]{2})/,/^(?:\\u[0-9a-fA-F]{4})/,/^(?:\\u\{[0-9a-fA-F]{1,6}\})/,/^(?:\\0)/,/^(?:\\')/,/^(?:\\")/,/^(?:\\`)/,/^(?:\\\\)/,/^(?:\\n)/,/^(?:\\r)/,/^(?:\\v)/,/^(?:\\t)/,/^(?:\\b)/,/^(?:\\f)/,/^(?:[\\](\r\n|\r|\n)\s*)/,/^(?:\\.)/,/^(?:(\r\n|\r|\n)+)/,/^(?:$)/,/^(?:["])/,/^(?:['])/,/^(?:[`])/,/^(?:.)/,/^(?:[/][*])/,/^(?:(\r\n|\r|\n)+)/,/^(?:$)/,/^(?:[*][/])/,/^(?:.)/,/^(?:\s+)/,/^(?:\r)/,/^(?:\n)/,/^(?:,)/,/^(?:;)/,/^(?:local\b)/,/^(?:global\b)/,/^(?:define\b)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:first\b)/,/^(?:with\b)/,/^(?:each\b)/,/^(?:NaN\b)/,/^(?:Infinity\b)/,/^(?:pi\b)/,/^(?:if\b)/,/^(?:then\b)/,/^(?:elif\b)/,/^(?:elsif\b)/,/^(?:elseif\b)/,/^(?:else\b)/,/^(?:endif\b)/,/^(?:case\b)/,/^(?:when\b)/,/^(?:end\b)/,/^(?:in\b)/,/^(?:done\b)/,/^(?:do\b)/,/^(?:and\b)/,/^(?:or\b)/,/^(?:not\b)/,/^(?:[\p{Alphabetic}_$][\p{Alphabetic}0-9_$]*\b)/u,/^(?:[0-9]+(\.[0-9]*)?([eE][+-]?[0-9]+)?\b)/,/^(?:0x[0-9A-Fa-f]+\b)/,/^(?:0o[0-7]+\b)/,/^(?:0b[01]+\b)/,/^(?:\.\.)/,/^(?::)/,/^(?:\*\*)/,/^(?:\*)/,/^(?:\/)/,/^(?:%)/,/^(?:-)/,/^(?:\+)/,/^(?:>>>)/,/^(?:<<)/,/^(?:>>)/,/^(?:<=)/,/^(?:>=)/,/^(?:<)/,/^(?:>)/,/^(?:===)/,/^(?:==)/,/^(?:!==)/,/^(?:!=)/,/^(?:<>)/,/^(?:\^)/,/^(?:&&)/,/^(?:\|\|)/,/^(?:!)/,/^(?:&)/,/^(?:\|)/,/^(?:~)/,/^(?:\?\?)/,/^(?:\?#)/,/^(?:\?\.)/,/^(?:\?\[)/,/^(?:\?)/,/^(?:=)/,/^(?:\.)/,/^(?:\[)/,/^(?:\])/,/^(?:\()/,/^(?:\))/,/^(?:\{)/,/^(?:\})/,/^(?:#[^\r\n]*)/,/^(?:$)/],
conditions: {"CMNT":{"rules":[26,27,28,29],"inclusive":false},"STRB":{"rules":[3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,23,24],"inclusive":false},"STRS":{"rules":[3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,22,24],"inclusive":false},"STRD":{"rules":[3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,24],"inclusive":false},"INITIAL":{"rules":[0,1,2,25,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109],"inclusive":true}}
});
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();
/* --------------------------- End of generated section (DO NOT EDIT ABOVE) --------------------------- */

    const f_min = function( ...args ) {
        let res = null;
        let n = args.length;
        for ( let i=0; i<n; i++ ) {
            let v = args[ i ];
            if ( Array.isArray( v ) ) {
                v = f_min.apply( null, v );
                if ( null !== v && ( null === res || v < res ) ) {
                    res = v;
                }
            } else if ( "number" === typeof v ) {
                if ( null === res || v < res ) {
                    res = v;
                }
            }
        }
        return res;
    };

    const f_max = function( ...args ) {
        let res = null;
        let n = args.length;
        for ( let i=0; i<n; i++ ) {
            let v = args[ i ];
            if ( Array.isArray( v ) ) {
                v = f_max.apply( null, v );
                if ( null !== v && ( null === res || v > res ) ) {
                    res = v;
                }
            } else if ( "number" === typeof v ) {
                if ( null === res || v > res ) {
                    res = v;
                }
            }
        }
        return res;
    };

    /**
     *  Helper function to handle string dates, which may be a simple time string or a date + time. This is highly
     *  simplified, taking advantage of some behaviors observed in node 16 that seem to slightly deviate from the
     *  spec. YMMV on what will parse to what, but ISO 8601 is explicitly supported by the Date() object and thus
     *  expected to always work. See further comment below.
     */
    const f_dtconv = function( s ) {
        s = String( s ); // insurance
        if ( "now" === s.toLowerCase() ) {
            return Date.now();
        }
        let r = s.match( /^\s*(\d+):(\d+)(:(\d+))?(\.(\d+))?/ ); // ??? last element could be tighter
        if ( r ) {
            /* Simple time format HH:MM[.SS[.uuu]] */
            let d = new Date();
            d.setHours( r[1] || 0, r[2] || 0, r[4] || 0, r[6] || 0 );
            return d.getTime();
        }

        /** Just let JS handle it. If it contains only a date (e.g. 7/15/2022), JS will make a midnight time for the
         *  correct date (at least in node 16.13) within the correct TZ (cool!). Otherwise, invalid date (getTime()=NaN).
         *  A date and time like "7/15/2022 12:34:56" is also handled correctly. Various date forms seem to be supported,
         *  like "2022-07-15" and "Jul 15, 2022" and "2022 July 15".
         */
        /** N.B. Humpf. nodejs 16.13.1, if the string does not contain a time component, the time generated is midnight
         *       ***UTC***, not midnight local. Oddly, if we supply midnight time, the result is midnight local. Seems
         *       like something is wrong here in JS, but we can work around it.
         */
        if ( ! s.match( /\d+:\d+/ ) ) {
            /* No time found, so add it. */
            s += ' 00:00:00.000';
        }
        return new Date( s ).getTime();
    };

    const nativeFuncs = {
          abs       : { nargs: 1, impl: (v) => v >= 0 ? v : -v }
        , sign      : { nargs: 1, impl: Math.sign }
        , floor     : { nargs: 1, impl: Math.floor }
        , ceil      : { nargs: 1, impl: Math.ceil }
        , round     : { nargs: 2, impl: function( n, p ) { return Math.round( n * Math.pow(10, p || 0) ) / Math.pow(10, p || 0); } }
        , trunc     : { nargs: 1, impl: Math.trunc }
        , cos       : { nargs: 1, impl: Math.cos }
        , sin       : { nargs: 1, impl: Math.sin }
        , tan       : { nargs: 1, impl: Math.tan }
        , acos      : { nargs: 1, impl: Math.acos }
        , asin      : { nargs: 1, impl: Math.asin }
        , atan      : { nargs: 1, impl: Math.atan }
        , atan2     : { nargs: 2, impl: Math.atan2 }
        , log       : { nargs: 1, impl: Math.log }
        , exp       : { nargs: 1, impl: Math.exp }
        , pow       : { nargs: 2, impl: Math.pow }
        , sqrt      : { nargs: 1, impl: Math.sqrt }
        , random    : { nargs: 0, impl: Math.random }
        , min       : { nargs: 1, impl: function( ...args ) { return f_min( null, ...args ); } }
        , max       : { nargs: 1, impl: function( ...args ) { return f_max( null, ...args ); } }
        , len       : { nargs: 1, impl: (s) => s.length }
        , substr    : { nargs: 2, impl: function( s, p, l ) { s = String(s); if (undefined===l) l=s.length; return s.substr(p,l); } }
        , upper     : { nargs: 1, impl: (s) => String(s).toUpperCase() }
        , lower     : { nargs: 1, impl: (s) => String(s).toLowerCase() }
        , match     : { nargs: 2, impl: function( s, p, n, f ) { let r = String(s).match( new RegExp( p, f ) ); return ( r === null ) ? null : r[n || 0]; } }
        , find      : { nargs: 2, impl: function( s, p, f ) { let r = String(s).match( new RegExp( p, f ) ); return ( r === null ) ? -1 : r.index; } }
        , replace   : { nargs: 3, impl: function( s, p, r, f ) { return String(s).replace( new RegExp( p, f ), r ); } }
        , rtrim     : { nargs: 1, impl: (s) => String(s).replace( /\s+$/, "" ) }
        , ltrim     : { nargs: 1, impl: (s) => String(s).replace( /^\s+/, "" ) }
        , trim      : { nargs: 1, impl: (s) => String(s).trim() }
        , split     : { nargs: 2, impl: (s,p,n) => String(s).split( p, n ) }
        , "int"     : { nargs: 1, impl: parseInt }
        , "float"   : { nargs: 1, impl: parseFloat }
        , "bool"    : { nargs: 1, impl: function( s ) { return !!s && null === String(s).match( /^\s*(0|no|off|false)\s*$/i ); } }
        , str       : { nargs: 1, impl: (s) => String(s) }
        , pad       : { nargs: 2, impl: (s,l,p) => l > 0 ? String(s)+(p||' ').repeat(Math.max(0,l-s.length)) : (p||' ').repeat(Math.max(0,-s.length-l))+String(s) }
        , quote     : { nargs: 1, impl: (s) => String(s).replace( /[\\"\b\f\n\r\t\v]/g, (t) => c_quot[t] || t ) }
        , hex       : { nargs: 1, impl: (n) => Number( n ).toString( 16 ) }
        , bin       : { nargs: 1, impl: (n) => Number( n ).toString( 2 ) }
        , oct       : { nargs: 1, impl: (n) => Number( n ).toString( 8 ) }
        , time      : { nargs: 0, impl: function( ...args ) {
                if ( 1 === args.length && ( null === args[0] || undefined === args.length ) ) {
                    return Date.now();
                } else if ( 1 === args.length && "object" === typeof ( args[0] ) ) {
                    /* Construct from dateparts() result */
                    let obj = args[0];
                    let now = new Date();
                    let d = (v,f) => ( "undefined" === typeof v || null === v ) ? f : v;
                    return new Date( d( obj.year, now.getFullYear() ),
                        ( "undefined" === typeof obj.month || null === obj.month ) ? 0 : ( obj.month-FEATURE_MONTH_BASE ),
                        d( obj.day, 1 ), d( obj.hour, 0 ), d( obj.minute, 0 ),
                        d( obj.second, 0 ), d( obj.millis, 0 ) ).getTime();
                } else if ( args.length === 1 && "string" === typeof( args[ 0 ] ) ) {
                    return f_dtconv( args[ 0 ] );
                } else if ( args.length === 1 && "number" === typeof( args[ 0 ] ) ) {
                    return new Date( args[0] ).getTime();
                } else if ( args.length > 1 && ! args.find( el => null !== el && "number" !== typeof el ) ) {
                    let now = new Date();
                    let d = (v) => undefined === v || null === v || Number.isNaN(v);
                    return new Date( d(args[0]) ? now.getFullYear() : args[0],
                        d(args[1]) ? now.getMonth() : (args[1]-FEATURE_MONTH_BASE),
                        d(args[2]) ? now.getDate() : args[2],
                        args[3] || 0, args[4] || 0, args[5] || 0, args[6] || 0
                    ).getTime();
                } else if ( 0 !== args.length ) {
                    throw new Error( "Invalid arguments to time()" );
                }
                return new Date( ...args ).getTime();
            }
        }
        , dateparts : { nargs: 0, impl: (m) => {
                let d = "undefined" === typeof m ? new Date() : new Date(m);
                let ret = { year: d.getFullYear(), month: d.getMonth()+FEATURE_MONTH_BASE, day: d.getDate(),
                         hour: d.getHours(), minute: d.getMinutes(), second: d.getSeconds(),
                         millis: d.getMilliseconds(), weekday: d.getDay() };
                /* Day of Year; ref: https://stackoverflow.com/posts/40975730/timeline */
                ret.yday = (Date.UTC(ret.year, ret.month-FEATURE_MONTH_BASE, ret.day) - Date.UTC(ret.year,0,0)) / 24 / 60 / 60 / 1000;
                /* ISO-8601 Week Number; ref: https://www.epochconverter.com/weeknumbers */
                let t = new Date( d.valueOf() );
                let dn = ( t.getDay() + 6 ) % 7;
                t.setDate( t.getDate() - dn + 3 );
                let fth = t.valueOf();
                t.setMonth( 0, 1 );
                if ( t.getDay() != 4 ) t.setMonth( 0, 1 + (( 4 - t.getDay() ) + 7) % 7 );
                ret.isoweek = 1 + Math.ceil( ( fth - t ) / 604800000 );
                /* DST. Get the current timezone offset first. */
                const coffs = Date.UTC( ret.year, ret.month-FEATURE_MONTH_BASE, ret.day, ret.hour, ret.minute, ret.second ) - d;
                /* Now get offsets for January and June, same year, day, time */
                const offs0 = Date.UTC( ret.year, 0, ret.day, ret.hour, ret.minute, ret.second ) - d.setMonth( 0 );
                const offs5 = Date.UTC( ret.year, 5, ret.day, ret.hour, ret.minute, ret.second ) - d.setMonth( 5 );
                /* If current offset is greater than Jan or Jun offset, we're in DST */
                ret.dst = coffs > offs0 || coffs > offs5;
                return ret;
            }
        }
        , "isNaN"   : { nargs: 1, impl: (n) => null === n || "undefined" === typeof n || Number.isNaN(n) || isNaN(n) }  /* See README */
        , isnull    : { nargs: 1, impl: (s) => "undefined" === typeof s || null === s }
        , isvalue   : { nargs: 1, impl: (s) => "undefined" !== typeof s && null !== s && ! Number.isNaN( s ) }
        , isInfinity: { nargs: 1, impl: (s) => ! isFinite(s) }
        , keys      : { nargs: 1, impl: Object.keys }
        , values    : { nargs: 1, impl: Object.values }
        , clone     : { nargs: 1, impl: (a) => JSON.parse( JSON.stringify( a ) ) }
        , join      : { nargs: 2, impl: (a,s) => a.join(s) }
        , list      : { nargs: 0, impl: function( ...args ) { return args; } }
        , indexOf   : { nargs: 2, impl: (a,el) => a.indexOf( el ) }
        , count     : { nargs: 1, impl: function( a ) {
                let n=0;
                Array.isArray( a ) ? a.forEach( el => { ( "undefined" !== typeof el && null !== el ) ? ++n : n; } ) : n;
                return n;
            }
        }
        , sum       : { nargs: 1, impl: function( a ) {
                let n=0; Array.isArray( a ) ? a.forEach( el => { ( "number" === typeof el ) ? n += el : 0; } ) : 0;
                return n;
            }
        }
        , median    : { nargs: 1, impl: (a) => {
                if ( Array.isArray( a ) && a.length > 0 ) {
                    let t = [ ...a ].sort( ( a, b ) => a - b ); /* Numeric sort of shallow copy (25286 fix) */
                    return ( 0 === ( t.length & 1 ) ) ? ( ( t[t.length/2-1] + t[t.length/2] ) / 2 ) : t[Math.floor( t.length / 2 )];
                }
                return null;
            }
        }
        , range     : { nargs: 3, impl: (s,e,i) => {
                let a = []; s = parseInt(s); e = parseInt(e); e = isNaN(e) ? s : e;
                if ( "number" === typeof s && "number" === typeof e ) {
                    i = parseInt(i);
                    if ( isNaN(i) ) i = Math.sign(e-s) || 1;
                    for (let k=s; a.length < MAX_RANGE && (i>0&&k<=e || i<0&&k>=e); k+=i) a.push(k);
                }
                return a;
            }
        }
        , constrain : { nargs: 2, impl: (n,mn,mx) => {
                n = parseFloat( n ); if ( isNaN(n) ) return NaN;
                mn = null === mn ? mn : parseFloat( mn );
                mx = ( undefined === mx || null === mx ) ? null : parseFloat( mx );
                return ( null !== mn && ! isNaN( mn ) && n < mn ) ? mn : ( ( null !== mx && ! isNaN( mx ) && n > mx ) ? mx : n );
            }
        }
        , scale     : { nargs: 2, impl: (n,fromMin,fromMax,toMin,toMax) => {
                n = nativeFuncs.constrain.impl( n, fromMin, fromMax ); if ( isNaN(n) ) return NaN;
                return ( n - fromMin ) * ( toMax - toMin ) / ( fromMax - fromMin ) + toMin;
            }
        }
        , concat    : { nargs: 2, impl: (a,b) => (a||[]).concat(b||[]) }
        , slice     : { nargs: 2, impl: (a,s,e) => (a||[]).slice( s, e ) }
        , insert    : { nargs: 2, impl: (a,p,...el) => { a.splice( p, 0, ...el ); return a; } }
        , remove    : { nargs: 2, impl: (a,s,n) => { a.splice( s, "undefined" === typeof n ? 1 : n ); return a; } }
        , push      : { nargs: 2, impl: (a,v,n) => { a = a || []; a.push(v); if ( n && a.length > n ) a.splice( 0, a.length-n ); return a; } }
        , pop       : { nargs: 1, impl: (a) => a.pop() }
        , unshift   : { nargs: 2, impl: (a,v,n) => { a = a || []; a.unshift(v); if ( n && a.length > n ) a.splice( n, a.length-n ); return a; } }
        , shift     : { nargs: 1, impl: (a) => a.shift() }
        , isArray   : { nargs: 1, impl: Array.isArray }
        , isObject  : { nargs: 1, impl: (p) => null !== p && "object" === typeof p }
        , sort      : { nargs: 1, impl: true } /* custom eval, see implementation of fref atom */
        , arrayConcat: { nargs: 2, impl: (a,b) => a.concat( b ) }
        , arrayIntersection: { nargs: 2, impl: (a,b) => a.filter( el => b.includes( el ) ) }
        , arrayDifference: { nargs: 2, impl: (a,b) => a.filter( el => ! b.includes( el ) ) }
        , arrayExclusive: { nargs: 2, impl: (a,b) => a.filter( el => ! b.includes( el ) ).concat( b.filter( el => ! a.includes( el ) ) ) }
        , arrayUnion: { nargs: 2, impl: (a,b) => a.concat( b.filter( el => ! a.includes( el ) ) ) }
        , toJSON    : { nargs: 1, impl: JSON.stringify }
        , parseJSON : { nargs: 1, impl: JSON.parse }
        , isJSON    : { nargs: 1, impl: (a) => { try { JSON.parse( a ); return true; } catch ( err ) { return false; } } }
        , btoa      : { nargs: 1, impl: (b) => Buffer.from( b, "utf-8" ).toString( "base64" ) }
        , atob      : { nargs: 1, impl: (a) => Buffer.from( a, "base64" ).toString( "utf-8" ) }
        , urlencode : { nargs: 1, impl: encodeURIComponent }
        , urldecode : { nargs: 1, impl: decodeURIComponent }
        , "typeof"  : { nargs: 1, impl: (a) => null === a ? 'null' : ( Array.isArray(a) ? 'array' : typeof a ) }
        , "err"     : { nargs: 1, impl: (s) => { throw new Error( String(s) ); } }
/* FUTURE:
        , format
        , dateadd
        , hsltorgb
        , rgbtohsl
*/
    };

    var D = false ? console.log : function() {};

    var get_context = function( vars ) {
        var c = { __lvar: vars || {}, __depth: 0, __tag: '$global', __func: {} };
        c.__global = c;
        c.__lvar.MAXINT = Number.MAX_SAFE_INTEGER;
        c.__lvar.MININT = Number.MIN_SAFE_INTEGER;
        c.__lvar.MAXFLOAT = Number.MAX_VALUE;
        c.__lvar.MINFLOAT = Number.MIN_VALUE;
        return c;
    };

    var push_context = function( ctx, tag, lvars ) {
        return {
            __global: ctx.__global || ctx,
            __parent: ctx,
            __depth: (ctx.__depth||0)+1,
            __lvar: lvars || {},
            __func: {},
            __tag: tag
        };
    };

    var pop_context = function( ctx ) {
        return ctx.__parent || ctx;
    };

    function locate_context( key, ctx, subkey ) {
        while ( ctx ) {
            let w = subkey ? ctx[ subkey ] : ctx;
            if ( w && key in w ) {
                return ctx;
            }
            if ( ! ctx.__parent ) {
                break;
            }
            ctx = ctx.__parent;
        }
        return false;
    }

    /**
     * Scan up from the given context for a context with the given tag. If no tag is given,
     * the first tagged context encountered is returned.
     */
    function find_context_tag( ctx, tag ) {
        if ( ctx.__tag && ( ! tag || ctx.__tag === tag ) ) {
            return ctx;
        }
        if ( ctx.__parent ) {
            return find_context_tag( ctx.__parent, tag );
        }
        return false;
    }

    function is_atom( v, typ ) {
        return null !== v && "object" === typeof( v ) &&
            "undefined" !== typeof v.__atom &&
            ( !typ || v.__atom === typ );
    }

    /** Return value given, remapping `undefined` to null. */
    function N( v ) {
        return "undefined" === typeof v ? null : v;
    }

    var run = function( ce, g_ctx ) {
        g_ctx = g_ctx || get_context();

        /* Resolve a VREF atom */
        function _resolve( a, ctx ) {
            /* Scope priority: local, context, external resolver */
            let res;

            /** NB Making a wierd departure (kludge) for Reactor here, allowing a function to be
             *  to be defined at a context level other than global. This is necessary for Reactor's
             *  Rule local variable dependency scan.
             */
            if ( ctx.__func?._ref ) {
                ctx.__func._ref( a.name, ctx );
            }

            /* If we find a variable at this scope (context) or any above, return its value */
            let c = locate_context( a.name, ctx, '__lvar' );
            if ( c ) {
                res = c.__lvar[ a.name ];
            } else {
                /* Not found; use resolver function if defined */
                c = locate_context( '_resolve', ctx, '__func' );
                if ( c ) {
                    res = c.__func._resolve( a.name, ctx );
                }
            }
            return N(res);
        }

        function _run( e, ctx ) {
            if ( !is_atom( e ) ) {
                if ( Array.isArray( e ) ) {
                    /* Run each element within array */
                    let res = [];
                    let n = e.length;
                    for ( let k=0; k<n; ++k ) {
                        res[k] = _run( e[k], ctx );
                    }
                    return res;
                } else if ( null !== e && "object" === typeof e ) {
                    let res = {};
                    Object.keys( e ).forEach( key => {
                        res[ key ] = _run( e[ key ], ctx );
                    });
                    return res;
                }
                return e; /* return primitive as it is. */
            } else {
                /* Handle atom */
                if ( is_atom( e, 'list' ) ) {
                    let v = null;
                    e.expr.forEach( function( se ) {
                        v = _run( se, ctx );
                    });
                    return N(v);
                } else if ( is_atom( e, 'vref' ) ) {
                    return N( _resolve( e, ctx ) );
                } else if ( is_atom( e, 'binop' ) ) {
                    const v2 = e.v2;
                    const v1 = e.v1;
                    let v1eval, v2eval;
                    if ( "=" !== e.op ) {
                        v1eval = _run( v1, ctx );
                    }
                    if ( e.op !== "&&" && e.op !== "||" && e.op !== '??' && e.op !== '?#' ) {
                        v2eval = _run( v2, ctx );
                    }
                    // D("binop v1=",v1,", v1eval=",v1eval,", v2=",v2,", v2eval=",v2);
                    if (e.op == '+') {
                        // Special case for plus (+): if either operand is string, treat as concat
                        if ( "string" === typeof v1eval || "string" === typeof v2eval ) {
                            v1eval = ( null === v1eval ? "" : v1eval.toString() ) + ( null === v2eval ? "" : v2eval.toString() );
                        } else {
                            v1eval += v2eval;
                        }
                    }
                    else if (e.op == '-')
                        v1eval -= v2eval;
                    else if (e.op == '*')
                        v1eval *= v2eval;
                    else if (e.op == '/')
                        v1eval /= v2eval;
                    else if (e.op == '**')
                        v1eval = v1eval**v2eval;
                    else if (e.op == '%')
                        v1eval %= v2eval;
                    else if (e.op == '&')
                        v1eval &= v2eval;
                    else if (e.op == '|')
                        v1eval |= v2eval;
                    else if (e.op == '^')
                        v1eval ^= v2eval;
                    else if (e.op == '>')
                        v1eval = v1eval > v2eval;
                    else if (e.op == '>=')
                        v1eval = v1eval >= v2eval;
                    else if (e.op == '<')
                        v1eval = v1eval < v2eval;
                    else if (e.op == '<=')
                        v1eval = v1eval <= v2eval;
                    else if (e.op == '==')
                        v1eval = v1eval == v2eval;
                    else if (e.op == '===')
                        v1eval = v1eval === v2eval;
                    else if (e.op == '!=')
                        v1eval = v1eval != v2eval;
                    else if (e.op == '!==')
                        v1eval = v1eval !== v2eval;
                    else if (e.op == '<<' )
                        v1eval = v1eval << v2eval;
                    else if (e.op == '>>' )
                        v1eval = v1eval >> v2eval;
                    else if (e.op == '>>>' )
                        v1eval = v1eval >>> v2eval;
                    else if (e.op == '&&') {
                        /* short-cut evaluation */
                        v1eval = v1eval && _run( v2, ctx );
                    } else if (e.op == '||') {
                        /* short-cut evaluation */
                        v1eval = v1eval || _run( v2, ctx );
                    } else if (e.op == 'in') {
                        v1eval = v1eval in v2eval;
                    } else if (e.op == '??') {
                        v1eval = ( null !== N(v1eval) ) ? v1eval : _run( v2, ctx );
                    } else if (e.op == '?#') {
                        /* ?# op returns numeric representation of left operand unless it's not a number, then right operand. */
                        v1eval = parseFloat( v1eval );  // null/undefined result NaN
                        v1eval = Number.isFinite( v1eval ) ? v1eval : _run( v2, ctx );  // isFinite() returns false for NaN and null
                    } else if ( ".." === e.op ) {
                        /* Range op */
                        let res = [];
                        if ( "number" !== typeof v1eval || "number" !== typeof v2eval ) {
                            throw new TypeError( "Non-numeric operand to range operator" );
                        }
                        let n = Math.floor( v1eval );
                        v2eval = Math.floor( v2eval );
                        let l = Math.abs( v2eval - n ) + 1;
                        if ( l > MAX_RANGE ) {
                            throw new RangeError( `Range exceeds maximum differential of ${MAX_RANGE}` );
                        }
                        if ( v2eval >= n ) {
                            while ( n <= v2eval ) {
                                res.push( n++ );
                            }
                        } else {
                            while ( n >= v2eval ) {
                                res.push( n-- );
                            }
                        }
                        v1eval = res;
                    } else if ( e.op == '=' ) {
                        /* Assignment */
                        if ( ! ( is_atom( v1, 'vref' ) || is_atom( v1, 'deref' ) ) ||
                                String( v1.name || "" ).startsWith( '__' ) ) {
                            throw new SyntaxError( `Invalid assignment target (${v1.name})` );
                        }
// D("run() assign",v2eval,"to",v1.name);
                        let c, res;
                        if ( is_atom( v1, 'deref' ) ) {
                            /* Assignment to member */
// D('ASSIGN deref context', v1.context, 'v2', v2);
                            let scope = _run( v1.context, ctx );
                            if ( "object" !== typeof scope || null === scope ) {
                                throw new ReferenceError( `Invalid scope in reference to member ${String(v1.member)} of (${typeof scope})${String(scope)}` );
                            }
                            let member = _run( v1.member, ctx );
                            /* Null and NaN don't pass here */
                            if ( Array.isArray( scope ) ) {
                                if ( "string" === typeof member && member == parseInt( member ) ) {
                                    member = parseInt( member );
                                }
                                if ( isNaN( member ) || ! Number.isFinite( member ) || member < 0 ) {
                                    // Array assignment must have numeric index
                                    const wh = is_atom( v1.context, 'vref' ) ? v1.context.name : scope;
                                    throw new ReferenceError( `Invalid reference to member (${typeof member})${String(member)} of array ${String(wh)}` );
                                }
                                member = parseInt( member );
                            } else if ( "string" !== typeof member || "" === member ) {
                                if ( "number" === typeof member ) {
                                    member = String( member );
                                } else {
                                    const wh = is_atom( v1.context, 'vref' ) ? v1.context.name : scope;
                                    throw new ReferenceError( `Invalid reference to member (${typeof member})${String(member)} of object ${String(wh)}` );
                                }
                            }
// D("ASSIGN",scope,".",member,"=",v2eval);
                            res = scope[ member ] = v2eval;
                        } else {
                            /* Simple assignment to identifier */
                            if ( e.global ) {
                                c = ctx.__global;
                            } else if ( e.local ) {
                                c = ctx;
                            } else {
                                /* Find nearest context that has name defined as a local variable (default current) */
                                c = locate_context( v1.name, ctx, '__lvar' ) || ctx;
                            }
                            c.__lvar = c.__lvar || {};
                            let fc = locate_context( '_assign', ctx, '__func' );
                            if ( fc && "function" === typeof fc.__func._assign ) {
                                /* If _assign() returns undefined, the normal assignment will be performed. Otherwise,
                                 * it is assumed that _assign() has done it.
                                 * Note that we are passing two contexts here: the context that the target identifier
                                 * was found in (c, where the assignment will be made), and the context in which the
                                 * expression is executing (ctx). This allows the callback function to determine where
                                 * the assignment is made from, for informational and debugging purposes.
                                 */
                                res = fc.__func._assign( v1.name, v2eval, c, e, ctx );
                            }
                            if ( "undefined" === typeof res ) {
                                res = c.__lvar[ v1.name ] = v2eval;
                            }
                        }
                        return res;
                    } else {
                        D( e );
                        throw new Error( `BUG: unsupported op in compiled expression: ${String(e.op)}` );
                    }
                    return v1eval;
                } else if ( is_atom( e, 'unop' ) ) {
                    let veval = _run( e.val, ctx );
                    if (e.op == '-')
                        veval = -veval;
                    else if (e.op == '!')
                        veval = !veval;
                    else if (e.op == '~')
                        veval = ~veval;
                    else
                        throw new Error( `BUG: unsupported unop in compiled expression: ${String(e.op)}` );
                    return veval;
                } else if ( is_atom( e, 'deref' ) ) {
                    let scope = _run( e.context, ctx );
                    /* Watch for null-conditional operators */
                    if ( ( e.op === '?.' || e.op == '?[' ) && scope === null ) {
                        return null;
                    }
                    if ( "object" !== typeof scope || null === scope ) {
                        throw new ReferenceError( `Invalid scope in reference to member ${String(e.member)} of (${typeof scope})${String(scope)}` );
                    }
                    let member = _run( e.member, ctx );
                    /* null and NaN are OK here, will likely produce null, which is OK */
                    if ( ! ( null === member || Number.isNaN( member ) || "number" === typeof member || "string" === typeof member ) ) {
                        throw new ReferenceError( `Invalid reference to member (${typeof member})${String(member)} of (${typeof scope})${String(scope)}` );
                    }
                    let res = _run( scope[ member ], ctx );
                    //D("DEREF",scope,".",member,"=",res);
                    return N(res);
                } else if ( is_atom( e, 'if' ) ) {
                    /* Special short-cut function */
                    if ( _run( e.test, ctx ) ) {
                        return N(_run( e.tc, ctx ));  /* if -> true -> then */
                    }
                    if ( e.alts ) {
                        /* elifs */
                        for ( let alt of e.alts ) {
                            if ( _run( alt.test, ctx ) ) {
                                return N(_run( alt.tc, ctx ));
                            }
                        }
                    }
                    if ( "undefined" !== typeof e.fc ) {
                        /* else */
                        return N(_run( e.fc, ctx ));
                    }
                    return null; /* default if no else */
                } else if ( is_atom( e, 'fref' ) ) {
                    // D('function ref ' + e.name + ' with ' + e.args.length + ' args');
                    let name = e.name;
                    let impl;
                    if ( "sort" === name ) {
                        /* Special implementation for sort() allows function reference or expr-
                        *  ession as second arg for custom sort. This requires a "late eval-
                        *  uation" (and multiple evaluations) of the sort function/expression.
                        */
                        let a = _run( e.args[0], ctx );
                        if ( ! Array.isArray( a ) ) {
                            throw new TypeError( "Requires array" );
                        }
                        a = [ ...a ];  // shallow-copy the array (a.sort() below sorts in place) (25286 fix)
                        ctx = push_context( ctx, "$sort" );
                        /* See if a custom sort is supplied. */
                        if ( e.args.length > 1 ) {
                            /* Can pass reference to defined function... */
                            if ( is_atom( e.args[1], 'vref' ) ) {
                                let c = locate_context( e.args[1].name, ctx, '__func' );
                                if ( c ) {
                                    impl = ( a, b ) => c.__func[ e.args[1].name ]( ctx, a, b );
                                }
                            }
                            if ( ! impl ) {
                                /* Assumed to be expression; preset $1 and $2 to comparison operands */
                                impl = function( a, b ) {
                                    ctx.__lvar.$1 = a;
                                    ctx.__lvar.$2 = b;
                                    let r = _run( e.args[1], ctx );
                                    return r;
                                };
                            }
                        }
                        if ( ! impl ) {
                            /* Default sort. Caller can define a locale-aware compare function, or
                            *  the default sort is used.
                            */
                            let c = locate_context( '_compare', ctx, '__func' );
                            if ( c ) {
                                impl = ( a, b ) => c.__func._compare( ctx, a, b );
                            }
                        }
                        a = a.sort( impl );
                        ctx = pop_context( ctx );
                        return a;
                    }
                    impl = false;
                    // Attached to context? Scan from current up.
                    let c = locate_context( name, ctx, '__func' );
                    if ( c ) {
                        impl = c.__func[ name ];
                    }
                    if ( ! impl && nativeFuncs[ name ] ) {
                        impl = ( fctx, ...args ) => nativeFuncs[ name ].impl( ...args );
                    }
                    if ( ! impl ) {
                        throw new ReferenceError( `Undefined function (${name})` );
                    }

                    // Build argument list and go. Context is always first argument.
                    let a = [ ctx ];
                    e.args.forEach( function( se ) {
                        a.push( _run( se, ctx ) );
                    });
                    let r = impl.apply( null, a );
                    return N(r);
                } else if ( is_atom( e, 'iter' ) ) {
                    ctx.__lvar = ctx.__lvar || {};
                    let context = N( _run( e.context, ctx ) );
                    let res = [];
                    if ( null !== context ) {
                        // D(e);
                        if ( "object" !== typeof context ) {
                            context = [ context ];
                        }
                        // D("Iterate over",context,"using",e.value,"apply",e.exec);
                        let local_ctx = push_context( ctx, "$iter" );
                        try {
                            for ( let [ key, value ] of Object.entries( context ) ) {
                                // D("Assigning",value,"to",e.value);
                                local_ctx.__lvar[ e.value ] = value;
                                if ( e.key ) {
                                    local_ctx.__lvar[ e.key ] = Array.isArray( context ) ? parseInt( key ) : key;
                                }
                                // D("Running",e.exec);
                                let v = _run( e.exec, local_ctx );
                                // D("result",v);
                                if ( v !== null ) {
                                    res.push( v );
                                }
                            }
                        } finally {
                            ctx = pop_context( local_ctx );
                        }
                    }
                    return res;
                } else if ( is_atom( e, 'search' ) ) {
                    let context = N( _run( e.context, ctx ) );
                    let res = null;
                    if ( null !== context ) {
                        ctx.__lvar = ctx.__lvar || {};
                        // D(e);
                        // D("Search",context,"using",e.value,"for",e.exec);
                        if ( "object" !== typeof context ) {
                            context = [ context ];
                        }
                        let local_ctx = push_context( ctx, "$srch" );
                        try {
                            for ( let [key, value] of Object.entries( context ) ) {
                                // D("Assigning",value,"to",e.value);
                                local_ctx.__lvar[ e.value ] = value;
                                if ( e.key ) {
                                    local_ctx.__lvar[ e.key ] = key;
                                }
                                let v = _run( e.exec, local_ctx );
                                if ( !!v ) {
                                    if ( e.result ) {
                                        res = _run( e.result, local_ctx );
                                    } else {
                                        res = value;
                                    }
                                    break;
                                }
                            }
                        } finally {
                            ctx = pop_context( local_ctx );
                        }
                    }
                    return res;
                } else if ( is_atom( e, 'block' ) ) {
                    let res = null;
                    try {
                        ctx = push_context( ctx, "$block" );
                        res = _run( e.block, ctx );
                    } finally {
                        ctx = pop_context( ctx );
                    }
                    return res;
                } else if ( is_atom( e, 'case' ) ) {
                    const list = e.when_list; // list atom
                    let res = null;
                    for ( let c of list.expr ) {
                        let cond = _run( c.test, ctx );
                        if ( cond ) {
                            res = _run( c.tc, ctx );
                            break;
                        }
                        if ( c.fc ) {
                            res = _run( c.fc, ctx );
                            break;
                        }
                    }
                    return res;
                } else if ( is_atom( e, 'fdef' ) ) {
                    const seen = {};
                    /* e.args is plain array of strings (argument names/identifiers; 25090 tighter, simplified structure) */
                    e.args.forEach( (a /* ,ix */ ) => {
                        if ( seen[ a ] ) {
                            throw new SyntaxError( `Duplicate argument name (${a})` );
                        }
                        seen[ a ] = true;
                    });
                    /* Define function; closure loads arguments values passed in to local variables in
                     * new sub-scope, then runs expression list in impl.
                     */
                    ctx.__func[ e.name ] = (ctx, ...args) => {
                        let res = null;
                        ctx = push_context( ctx, "$fdef" );
                        try {
                            /* Get each defined argument into its corresponding locally-scoped variable */
                            const n = e.args.length;
                            for ( let ix = 0; ix < n; ++ix ) {
                                let v = ix < args.length ? _run( args[ix], ctx ) : null;
                                D( "set arg", ix, e.args[ix], '=', v );
                                ctx.__lvar[ e.args[ ix ] ] = v;
                            }
                            res = _run( e.impl, ctx );
                        } finally {
                            ctx = pop_context( ctx );
                        }
                        return res;
                    };
                    return null;
                } else if ( is_atom( e, 'dict' ) ) {
                    /** 25086:
                     *  The dict atom is used rather than the previous direct initialization of an object during
                     *  parsing to make "{[key]:123}" initialization possible, where "key" is an expression that
                     *  (hopefully) resolves to a primitive. Previously, you had to use "d={},d[key]=123,d" to
                     *  get the same result.
                     */
                    let res = {};
                    for ( let v of e.elements ) {
                        //console.log("Element:",v);
                        let key = v.key;
                        let val = v.value;
                        if ( is_atom( key ) ) {
                            key = _run( key, ctx );
                            //console.log("    evaluated key",v.key,"to",key);
                        }
                        if ( is_atom( val ) ) {
                            val = _run( val, ctx );
                            //console.log("    evaluated value",v.value,"to",val);
                        }
                        res[key] = N(val);
                        //console.log("    adding to dict:", key, ":", val);
                    }
                    return res;
                } else {
                    D("BUG: unsupported atom:", e);
                    throw new Error( `BUG: unsupported atom (${String(e.__atom)})` );
                }
            }
        } /* function _run() */

        D("lexp.run()", ce, g_ctx);
        const result = _run( ce, g_ctx );
        D("lexp.run() finished with", result);
        return result;
    };

    function define_func_impl( ctx, name, impl ) {
        ctx.__func = ctx.__func || {};
        ctx.__func[ name ] = impl;
    }

    /** Define local variable in given context. */
    function define_var( ctx, name, val ) {
        ctx.__lvar = ctx.__lvar || {};
        ctx.__lvar[ name ] = N(val);
        return ctx.__lvar[ name ];
    }

    /** Define vars in the given context from key/value pairs (i.e. an Object). */
    function define_vars( ctx, vars ) {
        ctx.__lvar = ctx.__lvar || {};
        for ( let [name,value] of Object.entries( vars || {} ) ) {
            ctx.__lvar[ name ] = N( value );
        }
    }

    /** Set a variable in it's home context. If it doesn't exist in any context, create it in the leaf. */
    function set_var( ctx, name, val ) {
        let c = locate_context( name, ctx, '__lvar' );
        if ( ! c ) {
            return define_var( ctx, name, val );
        }
        c.__lvar[ name ] = val;
    }

    /** Get the value of the named variable. Search starts at the given context and goes up the tree until found
     *  or not, in which case we return `undefined`, distinct from `null` which is a valid variable value.
     */
    function get_var( ctx, name ) {
        let c = locate_context( name, ctx, '__lvar' );
        if ( c ) {
            return c.__lvar[ name ];
        }
        return undefined;
    }

    function undefine_var( ctx, name ) {
        delete ctx.__lvar[ name ];
    }

    function get_vars( ctx ) {
        return { ...ctx.__lvar };  // return shallow copy
    }

    function get_vrefs( ce ) {
        if ( ! is_atom( ce ) ) {
            throw new TypeError( "Argument is not compiled expression");
        }
        return ce.__vrefs;
    }

    function _compile( expr ) {
        __refs.clear();
        const ce = parser.parse( expr );
        ce.__vrefs = Array.from( __refs.values() );
        __refs.clear();
        return ce;
    }

    function _evaluate( expr, context ) {
        return run( parser.parse( expr ), context );
    }

    class CompiledExpression {
        constructor( expr, b ) {
            this.expr = expr;
            this.ce = b;
        }

        toString() {
            return this.expr;
        }

        get_vrefs() {
            return get_vrefs( this.ce );
        }

        evaluate( ctx ) {
            return LEXP.run( this.ce, ctx );
        /*
            if ( ctx && ! ( ctx instanceof ExpressionContext ) ) {
                throw new TypeError( "Invalid context" );
            }
            return run( this.ce, ctx ? ctx.getContext() : get_context() );
        */
        }
    }

    class ExpressionContext {
        constructor() {
            this.ctx = get_context();
        }

        defineFunction( name, impl ) {
            return define_func_impl( this.ctx, name, impl );
        }

        defineVar( name, val ) {
            return define_var( this.ctx, name, val );
        }

        setVar( name, val ) {
            return set_var( this.ctx, name, val );
        }

        getVar( name ) {
            return get_var( this.ctx, name );
        }

        push( tag ) {
            this.ctx = push_context( this.ctx, tag );
            return this;
        }

        /** Pop contexts up to and including tag. If tag is not specified, pop one level. */
        pop( tag ) {
            while ( this.ctx.__tag !== "$global" ) {
                if ( ! tag || this.ctx.__tag === tag ) {
                    this.ctx = pop_context( this.ctx );
                    return this;
                }
                this.ctx = pop_context( this.ctx );
            }
            return this;
        }

        getTag() {
            return this.ctx.__tag;
        }

        find( tag ) {
            const found = find_context_tag( this.ctx, tag );
            if ( ! found ) {
                return undefined;
            }
            const ret = new ExpressionContext();
            ret.ctx = found;
            return ret;
        }

        getGlobal() {
            const ret = new ExpressionContext();
            ret.ctx = this.ctx.__global;
            return ret;
        }

        getContext() {
            return this.ctx;
        }

        toString() {
            return `[object ExpressionContext#${this.ctx.__tag || ( '<' + this.ctx.__depth + '>' )}]`;
        }
    }

    class LEXP {
        constructor() {
            throw new TypeError( "Do not construct an instance of LEXP; all methods are static" );
        }

        static compile( expr ) {
            return new CompiledExpression( expr, _compile( expr ) );
        }

        static run( ce, ctx ) {
            if ( ! ( ce instanceof CompiledExpression ) ) {
                throw new TypeError( "Argument 1 must be a CompiledExpression" );
            }
            if ( ctx && ! ( ctx instanceof ExpressionContext ) ) {
                throw new TypeError( "Argument 2 must be a ExpressionContext" );
            }
            return run( ce.ce, ctx?.ctx );
        }

        static evaluate( expr, ctx ) {
            if ( ctx && ! ( ctx instanceof ExpressionContext ) ) {
                throw new TypeError( "Argument 2 must be a ExpressionContext" );
            }
            return LEXP.run( LEXP.compile( expr ), ctx );
        }

        static toString() {
            return '[class LEXP]';
        }
    }

    parser.yy.parseError = function(str, hash /* , ...args */) {
        if ( hash?.token === 'EOF' && Array.isArray(hash?.expected) && hash.expected.length > 0 )
            throw new Error(`Unexpected end of expression at line ${hash?.loc?.last_line} column ${hash?.loc?.last_column}`);
        throw new Error( str );
    };

    return {
        version: version,
        get_context: get_context,
        define_func_impl: define_func_impl,
        define_var: define_var,
        undefine_var: undefine_var,
        define_vars: define_vars,
        set_var: set_var,
        get_var: get_var,
        get_vars: get_vars,
        get_vrefs: get_vrefs,
        push_context: push_context,
        pop_context: pop_context,
        find_context_tag: find_context_tag,
        compile: _compile,
        run: run,
        evaluate: _evaluate,
        CompiledExpression: CompiledExpression,
        ExpressionContext: ExpressionContext,
        LEXP: LEXP
    };
}));
