#!/bin/sh

# Version 24341

if [ -d "./reactorui" -a -d "./server" -a -f "./storage" ]; then
	echo "This tool is only to be used from the Reactor install directory on bare-metal installations."
	exit 255
fi

if [ 0 -eq `id -u` ]; then
	echo "Please do not run this tool as 'root'. Run it as the non-privileged user that runs Reactor."
	exit 255
fi

U=`id -un`
G=`id -gn`

echo "Fixing ownership of `pwd` to ${U}:${G} (user:group). This may require you to enter your password."
sudo chown -R ${U}:${G} .

echo "Fixing permissions on `pwd`"
sudo chmod -R ug=rwX,o= .
sudo chmod -R ug+x *.sh ./tools/*.sh
